# Changing `auth.id` on a P4 Server

This document applies to existing P4 Server instances where `auth.id` is not yet set or needs to be changed, and describes the impact and considerations involved in making that change.

This change does not modify users, permissions, depots, changelist numbers, or versioned data.

When changing (or initially setting) the `auth.id` configurable on a P4 Server, it is important to understand both the one-time impact and the long-term benefits, as well as what the setting represents conceptually.

## Why set (or change) `auth.id`?

Setting or changing `auth.id` causes a one-time login disruption (described in detail below). However, it permanently and completely eliminates an entire class variety of ticket collisions ("ticket stomping") and inconsistent authentication behaviors across different connection paths, including a user connecting a client to different servers with the same `auth.id`. Once complete, authentication becomes more predictable, more robust, and significantly easier to support in complex or distributed P4 topologies or when there are multiple instances in the organization.

## What `auth.id` represents

The `auth.id` setting identifies a single P4 Server instance - that is, one logical system with a single set of versioned files, changelist numbers, users, protections, and metadata.

In a global topology (commit server, replicas, edges, brokers, etc.), all servers that belong to the same P4 instance share the same `auth.id` value. In that sense, `auth.id` is the identifier for the instance as a whole, not for any individual host.

At the same time, `auth.id` values must be unique within the organization. Different, unrelated P4 instances should always have different `auth.id` values, even if they coexist within the same organization or infrastructure.

The `rpl.forward.login` and `auth.id` work together to ensure consistent and correct ticket handling regardless of how users or tools connect to the server (hostname, IP, DNS alias, broker, replica, edge, etc.). This configuration eliminates a class of long-standing authentication and ticket-collision issues and is considered a best practice for modern P4 topologies.

### SDP auth.id Naming Convention

There is a naming convention that derives the `auth.id` value from the ServerID of the commit server.

The ServerID of the commit server is often named using the pattern:

`commit.<OrgName>.<Instance>`

The `auth.id` is derived from the commit ServerID by replacing `commit` with `p4_`, resulting in:

`p4_<OrgName>.<Instance>`

This linkage between commit ServerID and `auth.id` is purely a convention, _not a technical requirement_. The `auth.id` value can be set independently and does not have to be dervied from the commit ServerID.

The reason for this convention is practical rather than mechanical:

* The `<OrgName>.<Instance>` portion is guaranteed to be unique within the organization.
* It is human-readable and meaningful.
* It strikes a useful balance between uniqueness and clarity.

By contrast, a UUID - while technically unique - is opaque and meaningless to humans. Since the `auth.id` value appears directly in every user's P4TICKETS file, readability matters. When troubleshooting or auditing ticket files, it is helpful to be able to look at an entry and immediately tell which instance it belongs to.

The convention exists solely to make the `auth.id` value both unique and meaningful.

The convention connecting the ServerID of the commit to the SDP instance name is also intended to be useful and provide a reasonable default. However, the mechancial and functional requirement for `auth.id` to behave as desired is only that it be different for different instances.

For example, if you have two (or more) independent SDP instances, each created with the default SDP instance name of `1` but otherwise unrelated, they might initially have the same `auth.id` value of `p4_1`.  If used within the same organization, and users connect to different servers with the same `auth.id` value, this will cause ticket stomping issues.  Changing the `auth.id` is the required change to address this issue, and is the only required change. Changing the ServerID of the commit server and/or changing the SDP Instance name, e.g. to align with SDP or organizational conventions, is **optional**. Changing the `auth.id` is all that absolutely must be done -- it necessary and sufficient to eliminate ticket stomping issues.

## One-time impact

Setting or changing `auth.id` is disruptive exactly once. Most of the operational impact associated with changing `auth.id` comes from automation, not from human users:

* All existing login sessions become unusable from the client's perspective.
* All users (human and automated) must re-authenticate, typically via `p4 login`.
* Any automation, triggers, CI jobs, replication users, or integrations that rely on tickets must be accounted for as part of the change window

This happens because the format of P4 ticket storage changes, not because the tickets themselves are invalidated.

## How P4TICKETS files are affected

Before `auth.id` is set, entries in a P4TICKETS file look like this:

    IP:Port=User:Ticket

After `auth.id` is set, clients expect tickets in this format:

    localhost:auth.id=User:Ticket

Key points:

* The string `localhost` is literal and replaces the IP or hostname.
* The `auth.id` value replaces the port.
* Existing tickets are still cryptographically valid, but clients cannot locate them unless the entry format matches what the server expects.

Because of this, users and automation must either:

* Perform a fresh `p4 login`, which creates a new ticket entry in the new format.
* Have their existing P4TICKETS files rewritten to include new-format entries that reference the same ticket value.

This behavior applies to both human users and non-interactive accounts.

## Automation and integrations

Human users are usually prompted to log in again, so the disruption is typically minimal. Automation requires more deliberate planning:

* Systems using long-lived tickets (build systems, triggers, replication users, integrations, etc.) must be identified.
* If the ticket location is known, it is possible to pre-populate or rewrite P4TICKETS files so automation continues uninterrupted.
* APIs or integrations that pass raw tickets directly, without relying on a P4TICKETS file, are not affected by the format change.

Planning for automation is the most important factor in making this change smooth.

## Configuration Standards

The `rpl.forward.login=1` and `auth.id=<something>` configurables should _always_ be set as global defaults, i.e. for the `any` configuration.  That is, they should be like these examples:

`p4 configure set rpl.forward.login=1`

`p4 configure set auth.id=p4_MyOrg.fgs`

These should not be set for specific ServerIDs, because both should be global in scope, and there are no scenarios where it makes sense to allow per-ServerID variation for this configurables.  The `rpl.forward.login` setting only has effect on replicas (of all kinds); it does not affect the commit server.

## Operational considerations

* The change should be scheduled and communicated in advance
* All replica and edge servers must be restarted after setting `auth.id` and related configurables
* Many teams choose to bundle this change with other planned authentication changes, for example enabling LDAP or SSO, to consolidate user impact into a single maintenance window

### Alternative Management Style

While we generally advise the proper planning and smooth cutover mindset, there is an alternate strategy, the "Move Fast and Break Things" approach. This approach skips the risk of "analysis paralysis", e.g. attempting to identify all tools and systems integration owners and all possible code interacting with P4, and giving those teams time to investigate and prepare -- possibly taking weeks or months. Instead, one could broadly communicate the planned change and then make the `auth.id` change with reasonable notice. The theory is that issues will likely be discovered quickly and hopefully resolved as an urgent priority by various tool owners. Whether this approach is valid or crazy depends on your organization and the priority on smooth operations vs. being efficient. It may be sane to risk a few hours or days or instability to save weeks or months of delay.

## Related Information

See this related doc: [Changing Commit ServerID](Changing_Commit_ServerID.md)
