#!/usr/bin/env python3
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------

"""
This script makes sure that all Perforce users are in the limits group, so
that limits, specifically Max* settings in the group spec, can easily be
made to apply to all users. If used, this script owns and manages the
membership of the group named 'limits'.

This script's job is only to ensure that users are in the group.  It is expected
that the Perforce Admin will apply appropriate values to the Max* settings of
the group spec for the limits group.  Settings such values causes limits to be
applied.  Until limits are applied, membership in the limits group has no impact.

See 'p4 help group' for more information, and also see:

* https://portal.perforce.com/s/article/2521 
* https://portal.perforce.com/s/article/2529

BE CAREFUL:  Setting the values requires judgement and experience. If Max* values
are set too low, users will be unduly impacted, and will see errors indicating
that they have exceeded limits such as MaxScanRows or MaxOpenFiles. Appropriate
values depend on various factors such as server hardware resources and Helix
Core date size; there are not "one size fits all" values.

For users that should not have limits applied, create a group no_limits, and add
users (perhaps certain trusted automation users) to that group.  Set the Max*
values for that group to the special value 'unlimited'.

"""

import sys, os, string, re

instance=sys.argv[1]

os.system("/p4/common/bin/p4login %s" % instance)
os.system("/p4/common/bin/p4master_run %s /p4/%s/bin/p4_%s group -o limits > %s_limits.txt" % (instance, instance, instance, instance))
os.system("/p4/common/bin/p4master_run %s /p4/%s/bin/p4_%s -ztag -F %%User%% users > %s_users.txt" % (instance, instance, instance, instance))

users = open("%s_users.txt" % instance, "r")

limits = open("%s_limits.txt" % instance, "r")
output = open("%s_newlimits.txt" % instance, "w")

userlist = []

for user in users.readlines():
        user = user.strip()
        if user != "":
                userlist.append(user)

users.close()

for line in limits.readlines():
        if line != "\n":
                output.write(line)

limits.close()

for user in userlist:
        output.write("\t%s\n" % user)

output.close()

os.system("/p4/common/bin/p4master_run %s /p4/%s/bin/p4_%s group -i < %s_newlimits.txt > /dev/null" % (instance, instance, instance, instance))

os.remove("%s_users.txt" % instance)
os.remove("%s_limits.txt" % instance)
os.remove("%s_newlimits.txt" % instance)


