#!/usr/bin/env python

"""
This script is normally called by another script, such as archivelabels.py

However, if run standalone, it will generate 4 files with a list of specs
that should be archived based on the number of weeks in maintenance.cfg

The file generated are:

branches.txt
clients.txt
labels.txt
users.txt
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import os
import re
import sys
import time
import sdputils

if len(sys.argv) > 2:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()
cfgweeks = utils.get('weeks')


def log(msglevel="DEBUG", message=""):
  if msglevel == "ERROR":
    print(message)
    sys.exit(1)
  else:
    print(message)

def createlist(command, match_command, weeks):
  now = int(time.time())
  totalseconds = weeks * 7 * 24 * 60 * 60
  cutoff = now - totalseconds

  command_pattern = re.compile("^\.\.\. %s (.*)" % (match_command), re.IGNORECASE)
  access_pattern = re.compile("^\.\.\. Access (.*)", re.IGNORECASE)

  os.system("%s -Ztag %s > ztag.txt" % (p4, command))
  ztagfile = open("ztag.txt", "r", encoding='utf-8')

  specs = []
  try:
    line = ztagfile.readline()
    while line:
      match = command_pattern.match(line)
      if match != None:
        specname = match.group(1)

      match = access_pattern.match(line)
      if match != None:
        access = match.group(1)
        specs.append("%s,%s" % (access, specname))
      line = ztagfile.readline()
  except:
    log("ERROR", "Non unicode character in ztag.txt")

  ztagfile.close()
  specs.sort()

  finalfile = open("%s.txt" % (command), "w")
  for line in specs:
    splitline = line.split(",")
    if cutoff > int(splitline[0]):
      finalfile.write(splitline[1] + "\n")
  finalfile.close()

  os.remove("ztag.txt")


def main():
  # The final generated file {client,label,user}dates.txt will output a list of
  # {client,label,user}s that have not been accessed in the specified number of
  #  weeks.  Change the second parameter below if you want a different number
  # of weeks.

  createlist("branches", "branch", cfgweeks)
  createlist("clients", "client", cfgweeks)
  createlist("labels", "label", cfgweeks)
  createlist("users", "user", cfgweeks)


###############################################################################
# main
if __name__ == "__main__":
  main()
