#!/usr/bin/env python

"""
This script adds a user or users to the specified group.

Usage:
	python addusertogroup.py [instance] user group

instance defaults to 1 if not given.
user = user_name or a file containing a list of user names, one per line.
group = name of Perforce group to add the user(s) to.
"""

from __future__ import print_function

import sys
import os
import sdputils

if len(sys.argv) > 2:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()

###############################################################################
def main():
  if len(sys.argv) <= 2:
    print("Read the usage section at the top of the script for required parameters.")
    sys.exit(1)

  group = sys.argv[3]
  userlistfile= sys.argv[2]
  os.system("%s group -o %s > group.txt" % (p4, group))
  input = open("group.txt", "r")

  output = open("newgroup.txt", "w")

  for line in input.readlines():
    if line != "\n":
      output.write(line)

  try:
    userlist = open(userlistfile, "r")
    for user in userlist.readlines():
      output.write("\t" + user)
    userlist.close()
  except:
    print("No file " + userlistfile + " available, assuming it is the actual user name")
    output.write("\t" + userlistfile)

  output.close()
  input.close()

  os.system("%s group -i < newgroup.txt" % p4)
  os.remove("group.txt")
  os.remove("newgroup.txt")


###############################################################################
if __name__ == '__main__':
  main()
