#!/usr/bin/env python
#
# Note: This script will pull all the servers addresses off the servers output.
#       In order for that to work, you must add the Address field on each server form.
#
# Usage:
#	p4deleteuser.py [instance] user_to_remove
#	p4deleteuser.py [instance] file_with_users_to_remove
#
# What this scripts does:
#   Removes user and any clients/shelves owned by that user.
#
# instance defaults to 1 if not given.

import os
import sys
import accessdates
import removeuserfromgroups
import re
import sdputils

if len(sys.argv) > 2:  # see params above
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
p4_noport = utils.p4_noport 
utils.login()
cfgweeks = utils.get('userweeks')

sim = 0
clientlist = []
skipusers = ["p4admin", "perforce", "swarm"]
master_port = utils.server

######################################################################################################
def delete_clients (clientlist, sim):
  serverids = {}
  masterid = "master"
  for server in os.popen('%s -ztag -F "%ServerID%","%Address%","%Services%" servers' % (p4)).readlines():
    id, address, services = server.split(',')
    services = services.strip()
    if (services == "commit-server" or services == "standard"):
      masterid = id
    if (services == "edge-server" or services == "commit-server"):
      serverids.update({id.strip():address.strip()})
  for client in clientlist:
    print ("Deleting Client: %s" % (client))
    if sim == 0:
      p4port = master_port
      serverid = masterid
      client = client.strip()
      serverid_list = os.popen('%s -ztag -F %%ServerID%% client -o %s' % (p4, client)).readlines()
      if serverid_list:
        serverid = serverid_list[0].strip()
        p4port = serverids[serverid]
        utils.login(p4port)
      os.system('%s -c p4deleteuser -p %s -Ztag changes -s shelved -c %s > shelved.txt' % (p4_noport, p4port, client))
      if(os.path.isfile("shelved.txt")):
        shelvedfile = open("shelved.txt", "r")
        for changeline in shelvedfile.readlines():
          if re.search("\.\.\. change ", changeline):
            changenum = changeline[11:]
            changenum = changenum.strip()
            os.system('%s -c p4deleteuser -p %s shelve -c "%s" -df' % (p4_noport, p4port, changenum))
        shelvedfile.close()
        os.remove("shelved.txt")
      try:
        os.system('%s -c p4deleteuser -p %s client -f -d -Fs "%s"' % (p4_noport, p4port, client))
      except:
        try:
          os.system("%s -c p4deleteuser -p %s client -f -d -Fs '%s'" % (p4_noport, p4port, client))
        except:
          print("Could not delete client %s" % client)
      utils.login()

######################################################################################################
def delete_users(userlist, sim):
  for user in userlist:
    print("Deleting User: '%s'" % user)
    if sim == 0:
      os.system("%s user -f -d '%s'" % (p4, user))

######################################################################################################
def get_clients(userlist):
  for user in userlist:
    for line in os.popen("%s clients -u '%s'" % (p4, user)):
      client = line.split()[1]
      clientlist.append(client)
    for line in os.popen("%s clients -u '%s' -U" % (p4, user)):
      client = line.split()[1]
      clientlist.append(client)
    for line in os.popen("%s opened -u '%s'" % (p4, user)):
      client = re.sub('.*\@', '', line)
      client = re.sub('\*exclusive\*', '', client)
      client = re.sub('\*locked\*', '', client)
      client = client.strip()
      if client not in clientlist:
        clientlist.append(client)

######################################################################################################
def cleanup():
  os.remove('groups.txt')

######################################################################################################
def setup():
  os.system('%s groups > groups.txt' % p4)

######################################################################################################
def mainbody(userorfile):
  userlist = []

  try:
    input = open(userorfile, "r")
  except:
    print("Unable to open file %s assuming it is the username." % userorfile)
    user = userorfile.strip()
    userlist.append(user)
    removeuserfromgroups.automain(userlist)
    get_clients(userlist)
    delete_clients(clientlist, sim)
    delete_users(userlist, sim)
    cleanup()
    sys.exit(0)

  p4users = os.popen('p4 users | cut -d " " -f1').read()

  for line in input.readlines():
    line = line.strip()
    if line not in skipusers:
      if (line in p4users):
        userlist.append(line)

  input.close()

  removeuserfromgroups.automain(userlist)
  get_clients(userlist)
  delete_clients(clientlist, sim)
  delete_users(userlist, sim)
  cleanup()

######################################################################################################
def automain():
  accessdates.createlist("users", "user", cfgweeks)
  setup()
  mainbody("users.txt")

######################################################################################################
def main():
  if len(sys.argv) < 2:
    print("Read the usage section at the top of the script for required parameters.")
    sys.exit(1)

  setup()

  # Handle the optional instance parameter shift
  if len(sys.argv) > 2:
    mainbody(sys.argv[2])
  else:
    mainbody(sys.argv[1])

######################################################################################################
if __name__ == '__main__':
  main()
