#!/usr/bin/env python

USAGE = """
This script will look for the specified users in all groups and remove them.

Usage:
  removeuserfromgroups.py [instance] USER
  removeuserfromgroups.py [instance] FILE

USER can be a single username or, it can be a FILE with a list of users.

instance defaults to 1 if not given.
"""

import os
import re
import sys
import sdputils

if len(sys.argv) > 2:  # see params above
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()

def rep(mo): return '_%s' % hex(ord(mo.group(0)))[-2:]

def removeuserfromfile(groupfile, username):
  infile = open(groupfile, "r")
  outfile = open(groupfile + ".new", "w")
  for line in infile.readlines():
    if username.lower() != (line.strip()).lower():
      outfile.write(line)
  infile.close()
  outfile.close()
  os.remove(groupfile)
  newgroupfile = groupfile + ".new"
  os.rename(newgroupfile, groupfile)


def removeuser(username):
  usersgroups = []
  for line in os.popen("%s groups %s" % (p4, username)):
    line = line.strip()
    print("Removing %s from %s" % (username, line))
    groupname = re.sub(r'[\@=`~+<>/:\|\\ ,\(\)\[\]\$%^&?;{}\'\"]', rep, line)
    groupfile = "%s.group" % groupname
    if not os.path.exists(groupfile):
      os.system('%s group -o "%s" > %s' % (p4, line, groupfile))
    usersgroups.append(line)
    if line not in groups:
      groups.append(line.strip())

  for group in usersgroups:
    groupname = re.sub(r'[\@=`~+<>/:\|\\ ,\(\)\[\]\$%^&?;{}\'\"]', rep, group)
    groupfile = "%s.group" % groupname
    removeuserfromfile(groupfile, username)


def savegroups():
  print("Saving groups on server")
  for group in groups:
    groupname = re.sub(r'[\@=`~+<>/:\|\\ ,\(\)\[\]\$%^&?;{}\'\"]', rep, group)
    groupfile = "%s.group" % groupname
    os.system("%s group -i < %s" % (p4, groupfile))


def cleanup():
  print("Cleaning temp files")
  for group in groups:
    try:
      groupname = re.sub(r'[\@=`~+<>/:\|\\ ,\(\)\[\]\$%^&?;{}\'\"]', rep, group)
      groupfile = "%s.group" % groupname
      os.remove(groupfile)
    except:
      print("Failed to delete %s." % groupfile)


def automain(userlist):
  global initialized
  initialized = 0
  global groups
  groups = []
  for user in userlist:
    removeuser(user)
  savegroups()
  cleanup()


def main():
  if len(sys.argv) < 2:
    print(USAGE)
    sys.exit(1)

  # Handle the optional instance parameter shift
  if len(sys.argv) > 2:
    userorfile = (sys.argv[2])
  else:
    userorfile = (sys.argv[1])

  global initialized
  initialized = 0
  global groups
  groups = []

  try:
    userlistfile = open(userorfile, "r")
    for line in userlistfile.readlines():
      line = line.strip()
      if line:
        removeuser(line)
    userlistfile.close()
  except:
    print("No file %s available, assuming it is the actual user name." % userorfile)
    removeuser(userorfile.strip())

  savegroups()
  cleanup()


if __name__ == '__main__':
  main()
