#!/usr/bin/env python

"""
This script will unload clients not accessed since the weeks parameter specified
in maintenance.cfg. 
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import os
import re
import sys
import accessdates
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()
cfgweeks = utils.get('weeks')

def unload_clients():
  accessdates.createlist("clients", "client", cfgweeks)
  input = open("clients.txt", "r")

  for line in input.readlines():
    line = line.strip()
    line = re.sub("\$", "\\\$", line)
    line = '%s unload -f -L -z -c "%s"' % (p4, line)
    os.system(line)

  input.close()

###############################################################################
# main
if __name__ == '__main__':
  unload_clients()
