#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------
# 
# This is a radius test script.
# You need to install the python-pyrad package and python-six package for it to work.
# It also needs the file named dictionary in the same directory as the script.
#
# Set the Radius servers in radsvrs below
# Set the shared secret
# Pass in the user name as a parameter and the password from stdin.

import sys
from pyrad.client import Client
from pyrad.dictionary import Dictionary
import pyrad.packet

radsvrs = ["server1", "server2", "server3"]
sharedsecret = b"your_shared_secret"
user=sys.argv[1]
password = sys.stdin.read().strip()

for radsvr in radsvrs:
  srv = Client(server=radsvr, secret=sharedsecret, dict=Dictionary("dictionary"))

  # create request
  req = srv.CreateAuthPacket(code=pyrad.packet.AccessRequest, User_Name=user, NAS_Identifier="localhost")
  req["User-Password"] = req.PwCrypt(password)

  # send request
  reply = srv.SendPacket(req)

  if reply.code == pyrad.packet.AccessAccept:
    print("access accepted")
    sys.exit(0)
    
print("access denied")

print("Attributes returned by server:")
for i in reply.keys():
    print("%s: %s\n" % (i, reply[i]))
