# SDP Documentation Information

This page provides basic info on maintaining the SDP documentation.

SDP docs are primarily in ASCIIDoctor format (*.adoc), from which HTML and PDF files are generated.

During development, typically only HTML files (not PDF) are updated, as HTML is generally suitable for reviewing incremental changes.  PDFs are usually only updated during the release process (simply because they are much larger files).

# How to run

We use the `make` dependency engine to generate *.html and *.pdf files from the source *.adoc files, and also to generate *.html files from source *.md files.  The `make` utility is sensitive to your location in the directory tree, and it must be run from either of two directories relative to the workspace root:

<SDP_Workspace_Root>/doc
<SDP_Workspace_Root>/Unsupported/doc


When in one of the `doc` directories With the proper tools installed (see Installing Tools below), use the `make` command to generate docs.

To see what needs to be updated:

```
make -n
```

To generate an individual file, referred to as a `target` of `make`, reference that file in the command:

```
make SDP_Guide.Unix.html
```

Note that files may not be checked out.  You can check out files first, and use the special `clean` target to remove all generated files, re-generate them, and then `p4 reconcile` them to check out only changed files.  Something like this:

```
make clean all rec
```

The `clean` target removes all generated files.
The `all` target builds all target files.
The `rec` target calls `p4 rec` in the current directory.

Be sure to submit any modified files.  As noted above, if not doing a formal release, you can skip updating PDF files.

# Installing Tools

* `pandoc` for conversions from Word to AsciiDoc. (Only needed if any *.docx files remain).
* `asciidoctor` to generate basic HTML.
* `asciidoctor-pdf` to generate PDF output.

Downloads Information:

* https://asciidoctor.org/docs/user-manual/#system-requirements
* https://asciidoctor.org/docs/asciidoctor-pdf/#getting-started
* https://pandoc.org/installing.html

# Converting from MS Word

Conversions from Word done like this:

https://asciidoctor.org/docs/migrating-from-msword/

pandoc --from=docx --to=asciidoc --wrap=none --atx-headers --extract-media=extracted-media SDP_Guide.Unix#13.docx > output.adoc

You may need to look at the extracted-media directory.

# Finding non UTF8 chars

When converting from MS Word you may get an error message from `asciidoctor-pdf` about UTF8/binary problems 
and things like smart quotes, or em-dashes.

perl -ne 'print "$. $_" if m/[\x80-\xFF]/' SDP_Guide.Unix.adoc
