#!/bin/bash
set -u

# Abort on ANY error. This is intended to be a brittle script
# It checks and dies if anything is out of order.
set -e

#==============================================================================
# Declarations and Environment

declare ThisScript="${0##*/}"
declare Version=1.0.5
declare ThisUser=
declare ThisHost=${HOSTNAME%%.*}
declare CmdLine="${0} $*"
declare CfgDir="/p4/sdp/test/bsw"
declare -i ErrorCount=0
declare Log=
declare LogLink="/tmp/${ThisScript%.sh}.log"
declare H1="@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"

#==============================================================================
# Local Functions

function msg () { echo -e "$*"; }
function errmsg () { msg "\\nError: ${1:-Unknown Error}\\n"; ErrorCount+=1; }
function bail () { errmsg "${1:-Unknown Error}"; exit "$ErrorCount"; }

#==============================================================================
# Main Program

[[ "$CfgDir" == "$PWD" ]] || bail "Before calling this, do: cd $CfgDir"

[[ -n "$Log" ]] || Log="/tmp/${ThisScript%.sh}.$(date +'%Y-%m-%d-%H%M%S').log"

touch "$Log" || bail "Couldn't touch log file [$Log]."

# Redirect stdout and stderr to a log file.
exec > >(tee "$Log")
exec 2>&1

# Setup /tmp/test_sdp.log symlink so it points to the current log.
rm -f "$LogLink"
ln -s "$Log" "$LogLink"

msg "${H1}\\nLog is: $Log\\n"

ThisUser=$(id -n -u)
msg "Started $ThisScript v$Version as $ThisUser@$ThisHost on $(date) as pid $$:\\nInitial Command Line:\\n$CmdLine\\n"

msg "\\nRunning all tests in bash 'set -e' mode -- the first failure aborts the test run."

msg "\\nOperating in configuration directory: $PWD"

msg "\\n${H1}\\nINTERNAL TEST SUITE 1 for run_cli_tests.sh"

cd t1
./r

msg "\\n${H1}\\nINTERNAL TEST SUITE 2 for run_scripted_tests.sh"
cd ../t2
./r

msg "\\n${H1}\\nTEST SUITE 3 using run_cli_tests.sh"
cd ..
./run_cli_tests.sh

msg "\\n${H1}\\nTEST SUITE 4 using run_scripted_tests.sh"
./run_scripted_tests.sh

# Due to 'set -e' mode, if we got this far, it is certain that there
# were no errors.  Each of the scripts above has a reliable exit code.
msg "\\nSUCCESS:  ALL TEST SUITES COMPLETED OK!"

msg "\\nTime: All test suites completed in $((SECONDS/3600)) hours $((SECONDS%3600/60)) minutes $((SECONDS%60)) seconds."

msg "\\nLog is: $Log\\n${H1}"
