# Streams Adoption Guide - 2015
This is a guide to help Perforce customers understand how to adopt and move to the Helix Core Streams Branching Model. This guide was written by Perforce Consulting in 2015.

Streams allows you compartmentalize and componentize your development process, such that isolated changes, can be moved between branches in a hierarchy. There is intelligence built into streams that provides a indication of how data should flow between connected branches. Streams also provides a fundamental data movement philosophy that was coined by Laura Wingerd, former Chief Architect of Perforce, called the "Mainline Model Flow of Change." 

The Mainline Model provides a structure and a process that was described as, "merge-down/copy-up." Laura referred to this flow of change as the "tofu scale." Whereby streams are stratified into soft and firm branches. All streams are related as children or grandchildren of the mainline. Child streams are created from the mainline or the mainline's children. Those children that describe a fixed release are called "release" streams and are said to be "firm"; meaning no new features or functionality, only bug fixes. Bug fixes are then, "merged" down to the mainline where they can be preserved and included in the next release. Children of the mainline that are meant for experimental work or new features to be included in the next release are called "development" streams. Changes in development streams are "copied" to their parent stream. Doing so will overwrite any files that were inherited from the parent with the changes in the child stream. So, it is imperative that the child first, merge-down changes from the parent, before copying changes to the parent. That way, any important bug fixes or other new features are recorded in the child before changes are committed to the parent (mainline). Streams is modeled to ensure this is well known to users and has policy mechanisms to ensure that the "merge-down/copy-up" flow of change is preserved.