#
# Hints for Windows platforms.
#
use Config;

if ( $Config{cc} =~ /gcc\.exe/i ) {
    # With MinGW we require the following
    $self->{CCFLAGS} .= " -x c++";
} else {
    # Ensure we're using /TP
    $self->{DEFINE} .= " /TP";
}

# Make sure we're not linking with -debug on Windows as the linker chokes
# (the Perforce API is assumed to not be a debug build).
$self->{LDDLFLAGS} = $Config{ 'lddlflags' };
$self->{LDDLFLAGS} =~ s/ -debug//g;

#
# Hint that our OS name is 'NT' rather than anything else
#
$self->{P4PERL_OS_HINT} = "NT";
$self->{P4PERL_OSVER_HINT} = "";
