use Test::More tests => 9;
BEGIN { use_ok('P4'); }    ## test 1

# Load test utils
unshift( @INC, "." );
unshift( @INC, "t" );
require_ok("p4test");      ## test 2

our %count;

# ---- MyProgress Class -----------------------------------------------------
package TestProgress; 
{
	use base qw( P4::Progress );
	
	sub Init {
	    my $self = shift;
	    $count->{Description} = 0;
		$count->{Update} = 0;
		$count->{Total} = 0;
		$count->{Done} = 0;
	}
	
	sub Description {
	    my $self = shift;
	    $count->{Description}++;
	}
	
	sub Update {
	    my $self = shift;
	    $count->{Update}++;
	}
	
	sub Total {
	    my $self = shift;
	    $count->{Total}++;
	}
	
	sub Done {
	    my $self = shift;
	    my $fail = shift;
		$count->{Done}++;
		return $fail;
	}
}	


# ---- Main Class -----------------------------------------------------------
package main;

my $test = new P4::Test;
my $p4   = $test->InitClient();

ok( defined($p4) );        					## test 3
ok( $p4->Connect() );      					## test 4


## new sub classed progress object
my $progress = new TestProgress();
ok( $progress->isa(P4::Progress) );			## test 5


## test set/get methods
$p4->SetProgress($progress);
my $p = $p4->GetProgress();
ok( $p->isa(P4::Progress) );				## test 6
is( $p, $progress );						## test 7


## create and add test files (100 x 1K)
my $dir = "progress";
mkdir( $dir ) or die( "Can't create subdirectory '$dir'");

my $files = 10;
for (my $c=0; $c < $files; $c++) {
	my $f = "file$c.txt";
    my $p = "$dir/$f";
    
    open( FH, ">$p" ) or die( "Can't create '$p'" );
    my $blob = "-"; $blob x= 1024;
    print( FH "$blob\n" );
    close( FH );
    
    $p4->RunAdd( $p );
}


## test file count ...
my @opened = $p4->RunOpened();
ok( scalar( @opened ) == $files );			## test 8


## now submit with progress, check if any are left open.
my $change = $p4->FetchChange();
$change->{ 'Description' } = "Adding test progress files";
$p4->RunSubmit( $change );
@opened = $p4->RunOpened();
ok( scalar( @opened ) == 0 );				## test 9




