/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMerge;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientSendFile;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientSystemFileCommands;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientUserInteraction;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.callback.IProgressCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFunctionDispatcher {
    public static final String TRACE_PREFIX = "ClientFunctionDispatcher";
    private RpcPacketDispatcher mainDispatcher = null;
    private ClientUserInteraction userInteractor = null;
    private ClientSystemFileCommands fileCommands = null;
    private ClientSendFile fileSender = null;
    private ClientMerge clientMerger = null;
    private Properties props = null;
    protected RpcServer server = null;

    public ClientFunctionDispatcher(RpcPacketDispatcher mainDispatcher, Properties props, RpcServer server) {
        if (mainDispatcher == null) {
            throw new NullPointerError("Null main dispatcher passed to ClientFunctionDispatcher constructor");
        }
        this.props = props;
        this.server = server;
        this.mainDispatcher = mainDispatcher;
        this.userInteractor = new ClientUserInteraction(this.props, server);
        this.fileCommands = new ClientSystemFileCommands(this.props);
        this.fileSender = new ClientSendFile(this.props);
        this.clientMerger = new ClientMerge(this.props);
    }

    public RpcPacketDispatcher.RpcPacketDispatcherResult dispatch(RpcPacketDispatcher.RpcPacketDispatcherMode dispatchMode, RpcFunctionSpec funcSpec, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (funcSpec == null) {
            throw new NullPointerError("Null function spec passed to ClientFunctionDispatcher.dispatch()");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null command environment passed to ClientFunctionDispatcher.dispatch()");
        }
        RpcPacketDispatcher.RpcPacketDispatcherResult result = RpcPacketDispatcher.RpcPacketDispatcherResult.NONE;
        RpcConnection rpcConnection = cmdEnv.getRpcConnection();
        int cmdCallBackKey = cmdEnv.getCmdCallBackKey();
        IProgressCallback progressCallback = cmdEnv.getProgressCallback();
        boolean keepGoing = cmdEnv.isUserCanceled();
        if (progressCallback != null && keepGoing) {
            keepGoing = this.reportClientProgress(progressCallback, cmdCallBackKey, funcSpec, cmdEnv, resultsMap);
        }
        if (!keepGoing) {
            cmdEnv.setUserCanceled(true);
        }
        switch (funcSpec) {
            case CLIENT_MESSAGE: 
            case CLIENT_FSTATINFO: {
                if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.ANNOTATE.toString())) {
                    cmdEnv.handleResult(this.convertFileDataMap(resultsMap, cmdEnv.getRpcConnection().getClientCharset(), cmdEnv.getRpcConnection().isUnicodeServer()));
                } else if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.DIFF2.toString()) || cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.DESCRIBE.toString())) {
                    OutputStream outStream = (OutputStream)cmdEnv.getStateMap().get("");
                    String infoMsg = this.server.getInfoStr(resultsMap);
                    if (outStream != null && infoMsg != null) {
                        try {
                            infoMsg = infoMsg + "\n";
                            if (cmdEnv.getCmdSpec().getCmdName().equalsIgnoreCase(CmdSpec.DESCRIBE.toString())) {
                                outStream.write("... ".getBytes());
                            }
                            outStream.write(infoMsg.getBytes());
                        }
                        catch (IOException ioexc) {
                            Log.warn("Unexpected exception in client function dispatch: " + ioexc.getLocalizedMessage());
                        }
                    } else {
                        resultsMap.remove("func");
                        cmdEnv.handleResult(resultsMap);
                    }
                } else {
                    resultsMap.remove("func");
                    cmdEnv.handleResult(resultsMap);
                }
                result = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case CLIENT_PROMPT: {
                result = this.userInteractor.clientPrompt(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SETPASSWORD: {
                result = this.userInteractor.clientSetPassword(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CRYPTO: {
                result = this.userInteractor.clientCrypto(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CHMODFILE: {
                result = this.fileCommands.chmodFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OPENFILE: {
                result = this.fileCommands.openFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CHECKFILE: {
                result = this.fileCommands.checkFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_WRITEFILE: {
                result = this.fileCommands.writeFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CLOSEFILE: {
                result = this.fileCommands.closeFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_ACK: {
                result = this.userInteractor.clientAck(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_INPUTDATA: {
                result = this.userInteractor.clientInputData(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SENDFILE: {
                result = this.fileSender.sendFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_DELETEFILE: {
                result = this.fileCommands.deleteFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OUTPUTBINARY: {
                result = this.fileCommands.writeBinary(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OUTPUTTEXT: {
                result = this.fileCommands.writeText(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_MOVEFILE: {
                result = this.fileCommands.moveFile(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_OPENMERGE3: {
                result = this.clientMerger.clientOpenMerge3(rpcConnection, cmdEnv, resultsMap, false);
                break;
            }
            case CLIENT_OPENMERGE2: {
                result = this.clientMerger.clientOpenMerge3(rpcConnection, cmdEnv, resultsMap, true);
                break;
            }
            case CLIENT_WRITEMERGE: {
                result = this.clientMerger.clientWriteMerge(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_CLOSEMERGE: {
                result = this.clientMerger.clientCloseMerge(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            case CLIENT_SSO: {
                result = this.userInteractor.clientSingleSignon(rpcConnection, cmdEnv, resultsMap);
                break;
            }
            default: {
                Log.error("Unimplemented function spec in ClientFunctionDispatcher.dispatch(): '" + funcSpec.toString() + "'");
                throw new P4JavaError("Unimplemented function spec in ClientFunctionDispatcher.dispatch(): '" + funcSpec.toString() + "'");
            }
        }
        return result;
    }

    protected Map<String, Object> convertFileDataMap(Map<String, Object> map, Charset charset, boolean isUnicodeServer) {
        String dataString = null;
        byte[] dataBytes = null;
        try {
            dataBytes = (byte[])map.get("data");
        }
        catch (Throwable thr) {
            Log.exception(thr);
            return map;
        }
        if (map != null && dataBytes != null) {
            try {
                dataString = new String(dataBytes, charset == null ? RpcConnection.NON_UNICODE_SERVER_CHARSET_NAME : (isUnicodeServer ? CharsetDefs.UTF8_NAME : charset.name()));
            }
            catch (UnsupportedEncodingException e) {
                Log.exception(e);
                return map;
            }
            map.put("data", dataString);
        }
        return map;
    }

    protected boolean reportClientProgress(IProgressCallback progressCallback, int cmdCallBackKey, RpcFunctionSpec funcSpec, CommandEnv cmdEnv, Map<String, Object> resultsMap) {
        String FSTAT_NAME = "fstat";
        String FILES_NAME = "files";
        String UNKNOWN_NAME = "unknown";
        String JOBS_NAME = "jobs";
        String CHANGES_NAME = "changes";
        String USERS_NAME = "users";
        if (resultsMap != null) {
            String tickMarker = this.getTickMarker(resultsMap);
            String cmdName = cmdEnv.getCmdSpec().getCmdName();
            if (cmdName == null) {
                cmdName = "unknown";
            }
            switch (funcSpec) {
                case CLIENT_FSTATINFO: {
                    if (!cmdName.equalsIgnoreCase("fstat") && !cmdName.equalsIgnoreCase("files") && !cmdName.equalsIgnoreCase("jobs") && !cmdName.equalsIgnoreCase("changes") && !cmdName.equalsIgnoreCase("users")) break;
                    return progressCallback.tick(cmdCallBackKey, tickMarker);
                }
                case CLIENT_OPENFILE: 
                case CLIENT_SENDFILE: 
                case CLIENT_OUTPUTBINARY: 
                case CLIENT_OUTPUTTEXT: {
                    return progressCallback.tick(cmdCallBackKey, tickMarker);
                }
            }
        }
        return true;
    }

    private String getTickMarker(Map<String, Object> resultsMap) {
        String CHANGE_PFX = "changelist ";
        String CHANGE_KEY = "change";
        String JOB_KEY = "Job";
        String tickMarker = null;
        if (resultsMap != null) {
            String change;
            tickMarker = (String)resultsMap.get("path");
            if (tickMarker == null) {
                tickMarker = (String)resultsMap.get("clientFile");
            }
            if (tickMarker == null) {
                tickMarker = (String)resultsMap.get("depotFile");
            }
            if (tickMarker == null) {
                tickMarker = (String)resultsMap.get("Job");
            }
            if (tickMarker == null && (change = (String)resultsMap.get("change")) != null) {
                tickMarker = "changelist " + change;
            }
        }
        return tickMarker;
    }
}

