/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RpcLineEndFilterOutputStream
extends FilterOutputStream {
    public static final String P4SERVER_LINSEP_STR = "\n";
    public static final byte P4SERVER_LINSEP_BYTE = 10;
    private static final byte CR_BYTE = 13;
    private ClientLineEnding lineEnding = null;
    private byte[] localNewlineBytes = ClientLineEnding.FST_L_LOCAL_BYTES;
    private byte[] outBytes = null;

    public RpcLineEndFilterOutputStream(OutputStream out, ClientLineEnding lineEnding) {
        super(out);
        this.lineEnding = lineEnding;
        this.outBytes = new byte[10240];
        if (this.lineEnding == null) {
            throw new NullPointerError("null line ending spec in RpcLineEndFilterOutputStream constructor");
        }
        if (this.localNewlineBytes == null) {
            throw new NullPointerError("null local line ending bytes in RpcLineEndFilterOutputStream constructor");
        }
    }

    public void write(OutputStream out, byte[] bytes, int off, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerError("Null byte array passed to RpcLineEndFilterOutputStream.write()");
        }
        if (off < 0) {
            throw new P4JavaError("Negative byte array offset in RpcLineEndFilterOutputStream.write()");
        }
        if (len < 0) {
            throw new P4JavaError("Negative byte array length in RpcLineEndFilterOutputStream.write()");
        }
        if (off + len > bytes.length) {
            throw new P4JavaError("(off + len) > bytes.length in RpcLineEndFilterOutputStream.write()");
        }
        int outPos = 0;
        int inPos = off;
        byte b = 0;
        if (this.outBytes.length < bytes.length) {
            this.outBytes = new byte[bytes.length];
        }
        block5: for (int bytesIn = 0; bytesIn < len; ++bytesIn) {
            if ((b = bytes[inPos++]) == 10) {
                switch (this.lineEnding) {
                    case FST_L_LOCAL: {
                        for (byte nb : this.localNewlineBytes) {
                            if (outPos >= this.outBytes.length) {
                                out.write(this.outBytes, 0, outPos);
                                outPos = 0;
                            }
                            this.outBytes[outPos++] = nb;
                        }
                        continue block5;
                    }
                    case FST_L_CRLF: {
                        if (outPos >= this.outBytes.length) {
                            out.write(this.outBytes, 0, outPos);
                            outPos = 0;
                        }
                        this.outBytes[outPos++] = 13;
                        if (outPos >= this.outBytes.length) {
                            out.write(this.outBytes, 0, outPos);
                            outPos = 0;
                        }
                        this.outBytes[outPos++] = b;
                        break;
                    }
                    case FST_L_CR: {
                        if (outPos >= this.outBytes.length) {
                            out.write(this.outBytes, 0, outPos);
                            outPos = 0;
                        }
                        this.outBytes[outPos++] = 13;
                        break;
                    }
                    default: {
                        if (outPos >= this.outBytes.length) {
                            out.write(this.outBytes, 0, outPos);
                            outPos = 0;
                        }
                        this.outBytes[outPos++] = b;
                        break;
                    }
                }
                continue;
            }
            if (outPos >= this.outBytes.length) {
                out.write(this.outBytes, 0, outPos);
                outPos = 0;
            }
            this.outBytes[outPos++] = b;
        }
        if (outPos > 0) {
            out.write(this.outBytes, 0, outPos);
        }
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        this.write(this.out, bytes, off, len);
    }

    public void write(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerError("Null byte array passed to RpcLineEndFilterOutputStream.write()");
        }
        this.write(bytes, 0, bytes.length);
    }
}

