/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option.server;

import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFileAnnotationsOptions
extends Options {
    public static final String OPTIONS_SPECS = "b:a b:c b:i b:db b:dw b:dl b:I";
    protected boolean allResults = false;
    protected boolean useChangeNumbers = false;
    protected boolean followBranches = false;
    protected DiffType wsOpts = null;
    protected boolean ignoreWhitespaceChanges = false;
    protected boolean ignoreWhitespace = false;
    protected boolean ignoreLineEndings = false;
    protected boolean followAllIntegrations = false;

    public GetFileAnnotationsOptions() {
    }

    public GetFileAnnotationsOptions(String ... options) {
        super(options);
    }

    public GetFileAnnotationsOptions(boolean allResults, boolean useChangeNumbers, boolean followBranches, DiffType wsOpts) {
        this.allResults = allResults;
        this.useChangeNumbers = useChangeNumbers;
        this.followBranches = followBranches;
        this.wsOpts = wsOpts;
    }

    public GetFileAnnotationsOptions(boolean allResults, boolean useChangeNumbers, boolean followBranches, boolean ignoreWhitespaceChanges, boolean ignoreWhitespace, boolean ignoreLineEndings) {
        this.allResults = allResults;
        this.useChangeNumbers = useChangeNumbers;
        this.followBranches = followBranches;
        this.ignoreWhitespaceChanges = ignoreWhitespaceChanges;
        this.ignoreWhitespace = ignoreWhitespace;
        this.ignoreLineEndings = ignoreLineEndings;
    }

    public GetFileAnnotationsOptions(boolean allResults, boolean useChangeNumbers, boolean followBranches, boolean ignoreWhitespaceChanges, boolean ignoreWhitespace, boolean ignoreLineEndings, boolean followAllIntegrations) {
        this.allResults = allResults;
        this.useChangeNumbers = useChangeNumbers;
        this.followBranches = followBranches;
        this.ignoreWhitespaceChanges = ignoreWhitespaceChanges;
        this.ignoreWhitespace = ignoreWhitespace;
        this.ignoreLineEndings = ignoreLineEndings;
        this.followAllIntegrations = followAllIntegrations;
    }

    @Override
    public List<String> processOptions(IServer server) throws OptionsException {
        if (this.wsOpts != null) {
            switch (this.wsOpts) {
                case IGNORE_WS: {
                    this.setIgnoreWhitespace(true);
                    break;
                }
                case IGNORE_LINE_ENDINGS: {
                    this.setIgnoreLineEndings(true);
                    break;
                }
                case IGNORE_WS_CHANGES: {
                    this.setIgnoreWhitespaceChanges(true);
                }
            }
        }
        this.optionList = this.processFields(OPTIONS_SPECS, this.isAllResults(), this.isUseChangeNumbers(), this.isFollowBranches(), this.isIgnoreWhitespaceChanges(), this.isIgnoreWhitespace(), this.isIgnoreLineEndings(), this.isFollowAllIntegrations());
        return this.optionList;
    }

    public boolean isAllResults() {
        return this.allResults;
    }

    public GetFileAnnotationsOptions setAllResults(boolean allResults) {
        this.allResults = allResults;
        return this;
    }

    public boolean isUseChangeNumbers() {
        return this.useChangeNumbers;
    }

    public GetFileAnnotationsOptions setUseChangeNumbers(boolean useChangeNumbers) {
        this.useChangeNumbers = useChangeNumbers;
        return this;
    }

    public boolean isFollowBranches() {
        return this.followBranches;
    }

    public GetFileAnnotationsOptions setFollowBranches(boolean followBranches) {
        this.followBranches = followBranches;
        return this;
    }

    public DiffType getWsOpts() {
        return this.wsOpts;
    }

    public GetFileAnnotationsOptions setWsOpts(DiffType wsOpts) {
        this.wsOpts = wsOpts;
        return this;
    }

    public boolean isIgnoreWhitespaceChanges() {
        return this.ignoreWhitespaceChanges;
    }

    public GetFileAnnotationsOptions setIgnoreWhitespaceChanges(boolean ignoreWhitespaceChanges) {
        this.ignoreWhitespaceChanges = ignoreWhitespaceChanges;
        return this;
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public GetFileAnnotationsOptions setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
        return this;
    }

    public boolean isIgnoreLineEndings() {
        return this.ignoreLineEndings;
    }

    public GetFileAnnotationsOptions setIgnoreLineEndings(boolean ignoreLineEndings) {
        this.ignoreLineEndings = ignoreLineEndings;
        return this;
    }

    public boolean isFollowAllIntegrations() {
        return this.followAllIntegrations;
    }

    public GetFileAnnotationsOptions setFollowAllIntegrations(boolean followAllIntegrations) {
        this.followAllIntegrations = followAllIntegrations;
        return this;
    }
}

