/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Metadata {
    public static final String BUILT_VERSION_ATTRIBUTE = "P4Ant-Built-Version";
    public static final String BUILT_DATE_ATTRIBUTE = "P4Ant-Built-Date";
    public static final String BUILT_BY_ATTRIBUTE = "P4Ant-Built-By";
    private static String builtVersion = "Unknown";
    private static String builtDate = "Unknown";
    private static String builtBy = "Unknown";

    public static void main(String[] args) {
        Class<Metadata> clazz = Metadata.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (classPath.startsWith("jar")) {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            try {
                Manifest manifest = new Manifest(new URL(manifestPath).openStream());
                Attributes attr = manifest.getMainAttributes();
                for (Map.Entry<Object, Object> attribute : attr.entrySet()) {
                    if (attribute.getKey().toString().equalsIgnoreCase(BUILT_VERSION_ATTRIBUTE)) {
                        builtVersion = attribute.getValue().toString();
                        continue;
                    }
                    if (attribute.getKey().toString().equalsIgnoreCase(BUILT_DATE_ATTRIBUTE)) {
                        builtDate = attribute.getValue().toString();
                        continue;
                    }
                    if (!attribute.getKey().toString().equalsIgnoreCase(BUILT_BY_ATTRIBUTE)) continue;
                    builtBy = attribute.getValue().toString();
                }
            }
            catch (MalformedURLException ignore) {
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        System.out.println("P4Ant-Built-Version: " + builtVersion);
        System.out.println("P4Ant-Built-Date: " + builtDate);
        System.out.println("P4Ant-Built-By: " + builtBy);
    }
}

