/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesTask
extends ClientTask {
    protected int maxMostRecent = 0;
    protected String clientName = null;
    protected String userName = null;
    protected boolean includeIntegrated = false;
    protected IChangelist.Type type = null;
    protected boolean longDesc = false;
    protected String property = "p4.changelists";
    protected List<IChangelistSummary> retChangelistSummaries;

    public ChangesTask() {
        this.commandOptions = new GetChangelistsOptions(this.maxMostRecent, this.clientName, this.userName, this.includeIntegrated, this.type, this.longDesc);
    }

    public void setMaxMostRecent(int maxMostRecent) {
        ((GetChangelistsOptions)this.commandOptions).setMaxMostRecent(maxMostRecent);
    }

    public void setClientName(String clientName) {
        ((GetChangelistsOptions)this.commandOptions).setClientName(clientName);
    }

    public void setUserName(String userName) {
        ((GetChangelistsOptions)this.commandOptions).setUserName(userName);
    }

    public void setIncludeIntegrated(boolean includeIntegrated) {
        ((GetChangelistsOptions)this.commandOptions).setIncludeIntegrated(includeIntegrated);
    }

    public void setType(IChangelist.Type type) {
        ((GetChangelistsOptions)this.commandOptions).setType(type);
    }

    public void setLongDesc(boolean longDesc) {
        ((GetChangelistsOptions)this.commandOptions).setLongDesc(longDesc);
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public List<IChangelistSummary> getRetChangelistSummaries() {
        return this.retChangelistSummaries;
    }

    @Override
    protected void execP4Command() throws BuildException {
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.retChangelistSummaries = this.getP4Server().getChangelists(this.fileSpecs, (GetChangelistsOptions)this.commandOptions);
            this.logChangelistSummaries(this.retChangelistSummaries);
            StringBuilder sb = new StringBuilder();
            for (IChangelistSummary changelistSummary : this.retChangelistSummaries) {
                sb.append(changelistSummary.getId() + " ");
            }
            this.getProject().setProperty(this.property, "" + sb.toString().trim());
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

