/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ServerTask;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import org.apache.tools.ant.BuildException;

public abstract class ClientTask
extends ServerTask {
    protected IClient p4Client;

    public IClient getP4Client() {
        return this.p4Client;
    }

    public void setP4Client(IClient p4Client) {
        this.p4Client = p4Client;
    }

    private void initP4Client() {
        try {
            this.p4Client = this.p4Server.getClient(this.client);
            if (this.p4Client == null) {
                String errorMsg = this.p4Messages.getMessage("p4.client.unknown", new Object[]{this.client});
                throw new BuildException(errorMsg);
            }
            this.p4Server.setCurrentClient(this.p4Client);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }

    private void cleanupP4Client() {
        this.p4Client = null;
    }

    protected void initP4() throws BuildException {
        this.initP4Server();
        this.initP4Client();
    }

    protected void cleanupP4() throws BuildException {
        this.cleanupP4Client();
        this.cleanupP4Server();
    }
}

