/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ServerTask;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import org.apache.tools.ant.BuildException;

public class CounterTask
extends ServerTask {
    protected boolean delete = false;
    protected boolean perforceCounter = false;
    protected String name;
    protected String value;
    protected String property = "p4.counter";

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setPerforceCounter(boolean perforceCounter) {
        this.perforceCounter = perforceCounter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    protected void execP4Command() throws BuildException {
        if (this.isEmpty(this.name)) {
            throw new BuildException("No counter name specified.");
        }
        try {
            if (this.delete) {
                this.getP4Server().deleteCounter(this.name, this.perforceCounter);
                return;
            }
            if (this.isEmpty(this.value)) {
                this.value = this.getP4Server().getCounter(this.name);
            } else {
                this.getP4Server().setCounter(this.name, this.value, this.perforceCounter);
            }
            if (!this.isEmpty(this.property)) {
                this.getProject().setProperty(this.property, this.value);
            }
            int messagePriority = 2;
            StringBuilder message = new StringBuilder();
            message.append("counter {" + LINE_SEPARATOR);
            message.append("    ").append("name").append("=").append(this.name).append(LINE_SEPARATOR);
            message.append("    ").append("value").append("=").append(this.value).append(LINE_SEPARATOR);
            message.append("}" + LINE_SEPARATOR);
            this.log(message.toString(), messagePriority);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

