/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.server.GetFileDiffsOptions;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff2Task
extends ClientTask {
    protected String file1;
    protected String file2;
    protected String branch;
    protected boolean quiet = false;
    protected boolean includeNonTextDiffs = false;
    boolean gnuDiffs = false;
    protected boolean rcsDiffs = false;
    protected int diffContext = -1;
    protected boolean summaryDiff = false;
    protected int unifiedDiff = -1;
    protected boolean ignoreWhitespaceChanges = false;
    protected boolean ignoreWhitespace = false;
    protected boolean ignoreLineEndings = false;
    protected IFileSpec file1FileSpec;
    protected IFileSpec file2FileSpec;
    protected List<IFileDiff> retFileDiffs;

    public Diff2Task() {
        this.commandOptions = new GetFileDiffsOptions(this.quiet, this.includeNonTextDiffs, this.gnuDiffs, this.rcsDiffs, this.diffContext, this.summaryDiff, this.unifiedDiff, this.ignoreWhitespaceChanges, this.ignoreWhitespace, this.ignoreLineEndings);
    }

    public void setFile1(String file1) {
        this.file1 = file1;
    }

    public void setFile2(String file2) {
        this.file2 = file2;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setQuiet(boolean quiet) {
        ((GetFileDiffsOptions)this.commandOptions).setQuiet(quiet);
    }

    public void setIncludeNonTextDiffs(boolean includeNonTextDiffs) {
        ((GetFileDiffsOptions)this.commandOptions).setIncludeNonTextDiffs(includeNonTextDiffs);
    }

    public void setGnuDiffs(boolean gnuDiffs) {
        ((GetFileDiffsOptions)this.commandOptions).setGnuDiffs(gnuDiffs);
    }

    public void setRcsDiffs(boolean rcsDiffs) {
        ((GetFileDiffsOptions)this.commandOptions).setRcsDiffs(rcsDiffs);
    }

    public void setDiffContext(int diffContext) {
        ((GetFileDiffsOptions)this.commandOptions).setDiffContext(diffContext);
    }

    public void setSummaryDiff(boolean summaryDiff) {
        ((GetFileDiffsOptions)this.commandOptions).setSummaryDiff(summaryDiff);
    }

    public void setUnifiedDiff(int unifiedDiff) {
        ((GetFileDiffsOptions)this.commandOptions).setUnifiedDiff(unifiedDiff);
    }

    public void setIgnoreWhitespaceChanges(boolean ignoreWhitespaceChanges) {
        ((GetFileDiffsOptions)this.commandOptions).setIgnoreWhitespaceChanges(ignoreWhitespaceChanges);
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        ((GetFileDiffsOptions)this.commandOptions).setIgnoreWhitespace(ignoreWhitespace);
    }

    public void setIgnoreLineEndings(boolean ignoreLineEndings) {
        ((GetFileDiffsOptions)this.commandOptions).setIgnoreLineEndings(ignoreLineEndings);
    }

    public IFileSpec getFile1FileSpec() {
        return this.file1FileSpec;
    }

    public IFileSpec getFile2FileSpec() {
        return this.file2FileSpec;
    }

    public List<IFileDiff> getRetFileDiffs() {
        return this.retFileDiffs;
    }

    @Override
    protected void execP4Command() throws BuildException {
        try {
            this.file1FileSpec = new FileSpec(this.file1);
            this.file2FileSpec = new FileSpec(this.file2);
            this.retFileDiffs = this.getP4Server().getFileDiffs(this.file1FileSpec, this.file2FileSpec, this.branch, (GetFileDiffsOptions)this.commandOptions);
            this.logFileDiffs(this.retFileDiffs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

