/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.FixJobsOptions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixTask
extends ClientTask {
    protected String changelist = String.valueOf(0);
    protected String jobs;
    protected String status = null;
    protected boolean delete = false;
    protected List<IFix> retFixList;

    public FixTask() {
        this.commandOptions = new FixJobsOptions(this.status, this.delete);
    }

    public void setChangelist(String changelist) {
        this.changelist = changelist;
    }

    public void setJobs(String jobs) {
        this.jobs = jobs;
    }

    public void setStatus(String status) {
        ((FixJobsOptions)this.commandOptions).setStatus(status);
    }

    public void setDelete(boolean delete) {
        ((FixJobsOptions)this.commandOptions).setDelete(delete);
    }

    public List<IFix> getRetFixList() {
        return this.retFixList;
    }

    @Override
    protected void execP4Command() throws BuildException {
        if (this.isEmpty(this.jobs)) {
            throw new BuildException("No jobs specified.");
        }
        if (this.parseChangelist(this.changelist) == 0) {
            throw new BuildException("Cannot fix jobs with the default changelist.");
        }
        if (this.parseChangelist(this.changelist) < 0) {
            throw new BuildException("Must enter a valid changelist.");
        }
        try {
            this.retFixList = this.getP4Server().fixJobs(this.getJobs(), this.parseChangelist(this.changelist), (FixJobsOptions)this.commandOptions);
            this.logFixes(this.retFixList);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }

    protected LinkedList<String> getJobs() {
        String[] tokens;
        if (this.jobs != null && (tokens = this.jobs.trim().split("\\s+")) != null && tokens.length > 0) {
            return new LinkedList<String>(Arrays.asList(tokens));
        }
        return null;
    }
}

