/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileStatAncilliaryOptions;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetExtendedFilesOptions;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FstatTask
extends ClientTask {
    protected String filterString = null;
    protected int maxResults = 0;
    protected boolean reverseSort = false;
    protected int sinceChangelist = -1;
    protected int affectedByChangelist = -1;
    protected boolean sortByFiletype = false;
    protected boolean sortByDate = false;
    protected boolean sortByHeadRev = false;
    protected boolean sortByHaveRev = false;
    protected boolean sortByFileSize = false;
    private boolean mappedFiles = false;
    private boolean syncedFiles = false;
    private boolean openedNotHeadRevFiles = false;
    private boolean openedFiles = false;
    private boolean openedResolvedFiles = false;
    private boolean openedNeedsResolvingFiles = false;
    private boolean shelvedFiles = false;
    private boolean allRevs = false;
    private boolean fileSizeDigest = false;
    private boolean bothPathTypes = false;
    private boolean pendingIntegrationRecs = false;
    private boolean excludeLocalPath = false;
    protected List<IExtendedFileSpec> retExtendedFileSpecs;

    public FstatTask() {
        FileStatOutputOptions outputOptions = new FileStatOutputOptions(this.mappedFiles, this.syncedFiles, this.openedNotHeadRevFiles, this.openedFiles, this.openedResolvedFiles, this.openedNeedsResolvingFiles, this.shelvedFiles);
        FileStatAncilliaryOptions ancilliaryOptions = new FileStatAncilliaryOptions(this.allRevs, this.fileSizeDigest, this.bothPathTypes, this.pendingIntegrationRecs, this.excludeLocalPath);
        this.commandOptions = new GetExtendedFilesOptions(this.filterString, this.maxResults, this.reverseSort, this.sinceChangelist, this.affectedByChangelist, this.sortByFiletype, this.sortByDate, this.sortByHeadRev, this.sortByHaveRev, this.sortByFileSize, outputOptions, ancilliaryOptions);
    }

    public void setFilterString(String filterString) {
        ((GetExtendedFilesOptions)this.commandOptions).setFilterString(filterString);
    }

    public void setMaxResults(int maxResults) {
        ((GetExtendedFilesOptions)this.commandOptions).setMaxResults(maxResults);
    }

    public void setReverseSort(boolean reverseSort) {
        ((GetExtendedFilesOptions)this.commandOptions).setReverseSort(reverseSort);
    }

    public void setSinceChangelist(int sinceChangelist) {
        ((GetExtendedFilesOptions)this.commandOptions).setSinceChangelist(sinceChangelist);
    }

    public void setAffectedByChangelist(int affectedByChangelist) {
        ((GetExtendedFilesOptions)this.commandOptions).setAffectedByChangelist(affectedByChangelist);
    }

    public void setSortByFiletype(boolean sortByFiletype) {
        ((GetExtendedFilesOptions)this.commandOptions).setSortByFiletype(sortByFiletype);
    }

    public void setSortByDate(boolean sortByDate) {
        ((GetExtendedFilesOptions)this.commandOptions).setSortByDate(sortByDate);
    }

    public void setSortByHeadRev(boolean sortByHeadRev) {
        ((GetExtendedFilesOptions)this.commandOptions).setSortByHeadRev(sortByHeadRev);
    }

    public void setSortByHaveRev(boolean sortByHaveRev) {
        ((GetExtendedFilesOptions)this.commandOptions).setSortByHaveRev(sortByHaveRev);
    }

    public void setSortByFileSize(boolean sortByFileSize) {
        ((GetExtendedFilesOptions)this.commandOptions).setSortByFileSize(sortByFileSize);
    }

    public void setMappedFiles(boolean mappedFiles) {
        ((GetExtendedFilesOptions)this.commandOptions).getOutputOptions().setMappedFiles(mappedFiles);
    }

    public void setSyncedFiles(boolean syncedFiles) {
        ((GetExtendedFilesOptions)this.commandOptions).getOutputOptions().setSyncedFiles(syncedFiles);
    }

    public void setOpenedNotHeadRevFiles(boolean openedNotHeadRevFiles) {
        ((GetExtendedFilesOptions)this.commandOptions).getOutputOptions().setOpenedNotHeadRevFiles(openedNotHeadRevFiles);
    }

    public void setOpenedFiles(boolean openedFiles) {
        ((GetExtendedFilesOptions)this.commandOptions).getOutputOptions().setOpenedFiles(openedFiles);
    }

    public void setOpenedResolvedFiles(boolean openedResolvedFiles) {
        ((GetExtendedFilesOptions)this.commandOptions).getOutputOptions().setOpenedResolvedFiles(openedResolvedFiles);
    }

    public void setOpenedNeedsResolvingFiles(boolean openedNeedsResolvingFiles) {
        ((GetExtendedFilesOptions)this.commandOptions).getOutputOptions().setOpenedNeedsResolvingFiles(openedNeedsResolvingFiles);
    }

    public void setShelvedFiles(boolean shelvedFiles) {
        ((GetExtendedFilesOptions)this.commandOptions).getOutputOptions().setShelvedFiles(shelvedFiles);
    }

    public void setAllRevs(boolean allRevs) {
        ((GetExtendedFilesOptions)this.commandOptions).getAncilliaryOptions().setAllRevs(allRevs);
    }

    public void setFileSizeDigest(boolean fileSizeDigest) {
        ((GetExtendedFilesOptions)this.commandOptions).getAncilliaryOptions().setFileSizeDigest(fileSizeDigest);
    }

    public void setBothPathTypes(boolean bothPathTypes) {
        ((GetExtendedFilesOptions)this.commandOptions).getAncilliaryOptions().setBothPathTypes(bothPathTypes);
    }

    public void setPendingIntegrationRecs(boolean pendingIntegrationRecs) {
        ((GetExtendedFilesOptions)this.commandOptions).getAncilliaryOptions().setPendingIntegrationRecs(pendingIntegrationRecs);
    }

    public void setExcludeLocalPath(boolean excludeLocalPath) {
        ((GetExtendedFilesOptions)this.commandOptions).getAncilliaryOptions().setExcludeLocalPath(excludeLocalPath);
    }

    public List<IExtendedFileSpec> getRetExtendedFileSpecs() {
        return this.retExtendedFileSpecs;
    }

    @Override
    protected void execP4Command() throws BuildException {
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.retExtendedFileSpecs = this.getP4Server().getExtendedFiles(this.fileSpecs, (GetExtendedFilesOptions)this.commandOptions);
            this.logExtendedFileSpecs(this.retExtendedFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

