/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.MatchingLinesOptions;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrepTask
extends ClientTask {
    protected String pattern = null;
    protected boolean allRevisions = false;
    protected boolean caseInsensitive = false;
    protected boolean includeLineNumbers = false;
    protected boolean nonMatchingLines = false;
    protected boolean searchBinaries = false;
    protected int outputContext = 0;
    protected int trailingContext = 0;
    protected int leadingContext = 0;
    protected boolean fixedPattern = false;
    protected List<IFileLineMatch> fileLineMatches;

    public GrepTask() {
        this.commandOptions = new MatchingLinesOptions(this.allRevisions, this.caseInsensitive, this.includeLineNumbers, this.nonMatchingLines, this.searchBinaries, this.outputContext, this.trailingContext, this.leadingContext, this.fixedPattern);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setAllRevisions(boolean allRevisions) {
        ((MatchingLinesOptions)this.commandOptions).setAllRevisions(allRevisions);
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        ((MatchingLinesOptions)this.commandOptions).setCaseInsensitive(caseInsensitive);
    }

    public void setIncludeLineNumbers(boolean includeLineNumbers) {
        ((MatchingLinesOptions)this.commandOptions).setIncludeLineNumbers(includeLineNumbers);
    }

    public void setNonMatchingLines(boolean nonMatchingLines) {
        ((MatchingLinesOptions)this.commandOptions).setNonMatchingLines(nonMatchingLines);
    }

    public void setSearchBinaries(boolean searchBinaries) {
        ((MatchingLinesOptions)this.commandOptions).setSearchBinaries(searchBinaries);
    }

    public void setOutputContext(int outputContext) {
        ((MatchingLinesOptions)this.commandOptions).setOutputContext(outputContext);
    }

    public void setTrailingContext(int trailingContext) {
        ((MatchingLinesOptions)this.commandOptions).setTrailingContext(trailingContext);
    }

    public void setLeadingContext(int leadingContext) {
        ((MatchingLinesOptions)this.commandOptions).setLeadingContext(leadingContext);
    }

    public void setFixedPattern(boolean fixedPattern) {
        ((MatchingLinesOptions)this.commandOptions).setFixedPattern(fixedPattern);
    }

    public List<IFileLineMatch> getFileLineMatches() {
        return this.fileLineMatches;
    }

    @Override
    protected void execP4Command() throws BuildException {
        if (this.isEmpty(this.pattern)) {
            throw new BuildException("No pattern specified.");
        }
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.fileLineMatches = this.getP4Server().getMatchingLines(this.fileSpecs, this.pattern, (MatchingLinesOptions)this.commandOptions);
            this.logFileLineMatches(this.fileLineMatches);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

