/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.client.IntegrateFilesOptions;
import org.apache.tools.ant.BuildException;

public class IntegrateTask
extends ClientTask {
    protected String fromFile;
    protected String toFile;
    protected String changelist = String.valueOf(-1);
    protected boolean bidirectionalInteg = false;
    protected boolean integrateAroundDeletedRevs = false;
    protected boolean rebranchSourceAfterDelete = false;
    protected boolean deleteTargetAfterDelete = false;
    protected boolean integrateAllAfterReAdd = false;
    protected boolean forceIntegration = false;
    protected boolean useHaveRev = false;
    protected boolean doBaselessMerge = false;
    protected boolean displayBaseDetails = false;
    protected boolean showActionsOnly = false;
    protected boolean reverseMapping = false;
    protected boolean propagateType = false;
    protected boolean dontCopyToClient = false;
    protected String branch;
    protected int maxFiles = 0;
    protected IFileSpec fromFileSpec;
    protected IFileSpec toFileSpec;

    public IntegrateTask() {
        this.commandOptions = new IntegrateFilesOptions(this.parseChangelist(this.changelist), this.bidirectionalInteg, this.integrateAroundDeletedRevs, this.rebranchSourceAfterDelete, this.deleteTargetAfterDelete, this.integrateAllAfterReAdd, this.forceIntegration, this.useHaveRev, this.doBaselessMerge, this.displayBaseDetails, this.showActionsOnly, this.reverseMapping, this.propagateType, this.dontCopyToClient, this.maxFiles);
    }

    public void setFromFile(String fromFile) {
        this.fromFile = fromFile;
    }

    public void setToFile(String toFile) {
        this.toFile = toFile;
    }

    public void setChangelist(String changelist) {
        ((IntegrateFilesOptions)this.commandOptions).setChangelistId(this.parseChangelist(changelist));
    }

    public void setBidirectionalInteg(boolean bidirectionalInteg) {
        ((IntegrateFilesOptions)this.commandOptions).setBidirectionalInteg(bidirectionalInteg);
    }

    public void setIntegrateAroundDeletedRevs(boolean integrateAroundDeletedRevs) {
        ((IntegrateFilesOptions)this.commandOptions).setIntegrateAroundDeletedRevs(integrateAroundDeletedRevs);
    }

    public void setRebranchSourceAfterDelete(boolean rebranchSourceAfterDelete) {
        ((IntegrateFilesOptions)this.commandOptions).setRebranchSourceAfterDelete(rebranchSourceAfterDelete);
    }

    public void setDeleteTargetAfterDelete(boolean deleteTargetAfterDelete) {
        ((IntegrateFilesOptions)this.commandOptions).setDeleteTargetAfterDelete(deleteTargetAfterDelete);
    }

    public void setIntegrateAllAfterReAdd(boolean integrateAllAfterReAdd) {
        ((IntegrateFilesOptions)this.commandOptions).setIntegrateAllAfterReAdd(integrateAllAfterReAdd);
    }

    public void setForceIntegration(boolean forceIntegration) {
        ((IntegrateFilesOptions)this.commandOptions).setForceIntegration(forceIntegration);
    }

    public void setUseHaveRev(boolean useHaveRev) {
        ((IntegrateFilesOptions)this.commandOptions).setUseHaveRev(useHaveRev);
    }

    public void setDoBaselessMerge(boolean doBaselessMerge) {
        ((IntegrateFilesOptions)this.commandOptions).setDoBaselessMerge(doBaselessMerge);
    }

    public void setDisplayBaseDetails(boolean displayBaseDetails) {
        ((IntegrateFilesOptions)this.commandOptions).setDisplayBaseDetails(displayBaseDetails);
    }

    public void setShowActionsOnly(boolean showActionsOnly) {
        ((IntegrateFilesOptions)this.commandOptions).setShowActionsOnly(showActionsOnly);
    }

    public void setReverseMapping(boolean reverseMapping) {
        ((IntegrateFilesOptions)this.commandOptions).setReverseMapping(reverseMapping);
    }

    public void setPropagateType(boolean propagateType) {
        ((IntegrateFilesOptions)this.commandOptions).setPropagateType(propagateType);
    }

    public void setDontCopyToClient(boolean dontCopyToClient) {
        ((IntegrateFilesOptions)this.commandOptions).setDontCopyToClient(dontCopyToClient);
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setMaxFiles(int maxFiles) {
        ((IntegrateFilesOptions)this.commandOptions).setMaxFiles(maxFiles);
    }

    public IFileSpec getFromFileSpec() {
        return this.fromFileSpec;
    }

    public IFileSpec getToFileSpec() {
        return this.toFileSpec;
    }

    protected void execP4Command() throws BuildException {
        try {
            this.fromFileSpec = new FileSpec(this.fromFile);
            this.toFileSpec = new FileSpec(this.toFile);
            this.retFileSpecs = this.getP4Client().integrateFiles(this.fromFileSpec, this.toFileSpec, this.branch, (IntegrateFilesOptions)this.commandOptions);
            this.logFileSpecs(this.retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

