/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ServerTask;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobTask
extends ServerTask {
    protected boolean delete = false;
    protected String name = null;
    protected String fields = null;
    protected String property = "p4.job";
    protected IJob retJob;

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public IJob getRetJob() {
        return this.retJob;
    }

    @Override
    protected void execP4Command() throws BuildException {
        try {
            if (this.delete) {
                this.retStatusMessage = this.getP4Server().deleteJob(this.name);
                return;
            }
            Map<String, String> fields = this.getFields();
            if (this.isEmpty(this.name) || this.name.equalsIgnoreCase("new")) {
                this.retJob = this.createJob(fields);
                if (this.retJob != null) {
                    this.getProject().setProperty(this.property, this.retJob.getId());
                    this.logJob(this.retJob);
                }
                return;
            }
            if (!this.isEmpty(this.name)) {
                this.retJob = this.getP4Server().getJob(this.name);
                if (this.retJob != null) {
                    this.retJob = this.updateJob(fields, this.retJob);
                    this.getProject().setProperty(this.property, this.retJob.getId());
                    this.logJob(this.retJob);
                }
            }
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }

    private Map<String, Integer> getJobSpecFields(IJobSpec jobSpec) {
        HashMap<String, Integer> jobSpecFields = new HashMap<String, Integer>();
        if (jobSpec != null && jobSpec != null) {
            List fields = jobSpec.getFields();
            for (IJobSpec.IJobSpecField field : fields) {
                jobSpecFields.put(field.getName(), field.getCode());
            }
        }
        return jobSpecFields;
    }

    private IJob updateJob(Map<String, String> fields, IJob job) throws P4JavaException {
        if (job != null) {
            Map rawFields = job.getRawFields();
            HashMap<String, String> updateFields = new HashMap<String, String>(rawFields);
            IJobSpec jobSpec = this.getP4Server().getJobSpec();
            if (jobSpec != null) {
                Map<String, Integer> jobSpecFields = this.getJobSpecFields(jobSpec);
                for (String key : rawFields.keySet()) {
                    if (jobSpecFields.containsKey(key)) continue;
                    updateFields.remove(key);
                }
                updateFields.putAll(fields);
                job.setRawFields(updateFields);
                job.update();
            }
        }
        return job;
    }

    private IJob createJob(Map<String, String> fields) throws P4JavaException {
        IJob job = null;
        HashMap<String, String> rawFields = new HashMap<String, String>();
        IJobSpec jobSpec = this.getP4Server().getJobSpec();
        if (jobSpec != null) {
            List jobSpecFields = jobSpec.getFields();
            for (IJobSpec.IJobSpecField jobSpecField : jobSpecFields) {
                switch (jobSpecField.getCode()) {
                    case 101: {
                        rawFields.put(jobSpecField.getName(), "new");
                        break;
                    }
                    case 102: {
                        rawFields.put(jobSpecField.getName(), "open");
                        break;
                    }
                    case 103: {
                        rawFields.put(jobSpecField.getName(), this.user);
                        break;
                    }
                    case 104: {
                        rawFields.put(jobSpecField.getName(), "");
                        break;
                    }
                    case 105: {
                        rawFields.put(jobSpecField.getName(), "");
                        break;
                    }
                }
            }
            rawFields.putAll(fields);
            job = this.getP4Server().createJob(rawFields);
        }
        return job;
    }
}

