/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetJobsOptions;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobsTask
extends ClientTask {
    protected int maxJobs = 0;
    protected boolean longDescriptions = false;
    protected boolean reverseOrder = false;
    protected boolean includeIntegrated = false;
    protected String jobView = null;
    List<IJob> retJobs;

    public JobsTask() {
        this.commandOptions = new GetJobsOptions(this.maxJobs, this.longDescriptions, this.reverseOrder, this.includeIntegrated, this.jobView);
    }

    public void setMaxJobs(int maxJobs) {
        ((GetJobsOptions)this.commandOptions).setMaxJobs(maxJobs);
    }

    public void setLongDescriptions(boolean longDescriptions) {
        ((GetJobsOptions)this.commandOptions).setLongDescriptions(longDescriptions);
    }

    public void setReverseOrder(boolean reverseOrder) {
        ((GetJobsOptions)this.commandOptions).setReverseOrder(reverseOrder);
    }

    public void setIncludeIntegrated(boolean includeIntegrated) {
        ((GetJobsOptions)this.commandOptions).setIncludeIntegrated(includeIntegrated);
    }

    public void setJobView(String jobView) {
        ((GetJobsOptions)this.commandOptions).setJobView(jobView);
    }

    public List<IJob> getRetJobs() {
        return this.retJobs;
    }

    @Override
    protected void execP4Command() throws BuildException {
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.retJobs = this.getP4Server().getJobs(this.fileSpecs, (GetJobsOptions)this.commandOptions);
            this.logJobs(this.retJobs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

