/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Label;
import java.util.Date;
import org.apache.tools.ant.BuildException;

public class LabelTask
extends ClientTask {
    protected String name;
    protected String owner;
    protected String description;
    protected String revision;
    protected boolean locked = false;
    protected boolean delete = false;
    protected boolean force = false;
    protected ILabel retLabel;

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public ILabel getRetLabel() {
        return this.retLabel;
    }

    protected void execP4Command() throws BuildException {
        if (this.isEmpty(this.name)) {
            throw new BuildException("No label name specified.");
        }
        try {
            if (this.delete) {
                this.retStatusMessage = this.getP4Server().deleteLabel(this.name, this.force);
                return;
            }
            ViewMap viewMap = new ViewMap();
            String[] viewPaths = this.getFiles();
            for (int i = 0; i < viewPaths.length; ++i) {
                Label.LabelMapping entry = new Label.LabelMapping(i + 1, viewPaths[i]);
                viewMap.addEntry((IMapEntry)entry);
            }
            this.retLabel = this.getP4Server().getLabel(this.name);
            if (this.retLabel != null) {
                if (!this.isEmpty(this.owner)) {
                    this.retLabel.setOwnerName(this.owner);
                }
                this.retLabel.setLastUpdate(new Date());
                if (!this.isEmpty(this.description)) {
                    this.retLabel.setDescription(this.description);
                }
                if (!this.isEmpty(this.revision)) {
                    this.retLabel.setRevisionSpec(this.revision);
                }
                this.retLabel.setLocked(this.locked);
                if (viewMap != null && viewMap.getSize() > 0) {
                    this.retLabel.setViewMapping(viewMap);
                }
                this.retStatusMessage = this.getP4Server().updateLabel(this.retLabel);
                return;
            }
            Date lastAccess = null;
            Date lastUpdate = null;
            this.retLabel = new Label(this.name, this.user, lastAccess, lastUpdate, this.description, this.revision, this.locked, viewMap);
            this.retStatusMessage = this.getP4Server().createLabel(this.retLabel);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

