/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.LabelSyncOptions;
import org.apache.tools.ant.BuildException;

public class LabelsyncTask
extends ClientTask {
    protected String name;
    protected boolean noUpdate = false;
    protected boolean addFiles = false;
    protected boolean deleteFiles = false;

    public LabelsyncTask() {
        this.commandOptions = new LabelSyncOptions(this.noUpdate, this.addFiles, this.deleteFiles);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNoUpdate(boolean noUpdate) {
        ((LabelSyncOptions)this.commandOptions).setNoUpdate(noUpdate);
    }

    public void setAddFiles(boolean addFiles) {
        ((LabelSyncOptions)this.commandOptions).setAddFiles(addFiles);
    }

    public void setDeleteFiles(boolean deleteFiles) {
        ((LabelSyncOptions)this.commandOptions).setDeleteFiles(deleteFiles);
    }

    protected void execP4Command() throws BuildException {
        if (this.isEmpty(this.name)) {
            throw new BuildException("No label name specified.");
        }
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.retFileSpecs = this.getP4Client().labelSync(this.fileSpecs, this.name, (LabelSyncOptions)this.commandOptions);
            this.logFileSpecs(this.retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

