/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.server.MoveFileOptions;
import org.apache.tools.ant.BuildException;

public class MoveTask
extends ClientTask {
    protected String fromFile;
    protected String toFile;
    protected String changelist = String.valueOf(-1);
    protected boolean listOnly = false;
    protected boolean force = false;
    protected boolean noClientMove = false;
    protected String fileType = null;
    protected IFileSpec fromFileSpec;
    protected IFileSpec toFileSpec;

    public MoveTask() {
        this.commandOptions = new MoveFileOptions(this.parseChangelist(this.changelist), this.listOnly, this.force, this.noClientMove, this.fileType);
    }

    public void setFromFile(String fromFile) {
        this.fromFile = fromFile;
    }

    public void setToFile(String toFile) {
        this.toFile = toFile;
    }

    public void setChangelist(String changelist) {
        ((MoveFileOptions)this.commandOptions).setChangelistId(this.parseChangelist(changelist));
    }

    public void setListOnly(boolean listOnly) {
        ((MoveFileOptions)this.commandOptions).setListOnly(listOnly);
    }

    public void setForce(boolean force) {
        ((MoveFileOptions)this.commandOptions).setForce(force);
    }

    public void setNoClientMove(boolean noClientMove) {
        ((MoveFileOptions)this.commandOptions).setNoClientMove(noClientMove);
    }

    public void setFileType(String fileType) {
        ((MoveFileOptions)this.commandOptions).setFileType(fileType);
    }

    public IFileSpec getFromFileSpec() {
        return this.fromFileSpec;
    }

    public IFileSpec getToFileSpec() {
        return this.toFileSpec;
    }

    protected void execP4Command() throws BuildException {
        try {
            this.fromFileSpec = new FileSpec(this.fromFile);
            this.toFileSpec = new FileSpec(this.toFile);
            this.retFileSpecs = this.getP4Server().moveFile(this.fromFileSpec, this.toFileSpec, (MoveFileOptions)this.commandOptions);
            this.logFileSpecs(this.retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

