/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class PerforceProperties {
    private static final String PROPERTIES_FILE_SUFFIX = ".properties";

    private PerforceProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAsFile(String propertiesFileName) {
        Properties properties = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propertiesFileName);
            properties = new Properties();
            properties.load(fis);
        }
        catch (FileNotFoundException ignore) {
            properties = null;
        }
        catch (IOException ignore) {
            properties = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable ignore) {}
            }
        }
        return properties;
    }

    public static Properties loadAsResourceBundle(String propertiesFileName) {
        Properties properties = null;
        if (propertiesFileName.startsWith("/")) {
            propertiesFileName = propertiesFileName.substring(1);
        }
        if (propertiesFileName.endsWith(PROPERTIES_FILE_SUFFIX)) {
            propertiesFileName = propertiesFileName.substring(0, propertiesFileName.length() - PROPERTIES_FILE_SUFFIX.length());
        }
        propertiesFileName = propertiesFileName.replace('/', '.');
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            ResourceBundle rb = ResourceBundle.getBundle(propertiesFileName, Locale.getDefault(), loader);
            if (rb != null) {
                properties = new Properties();
                Enumeration<String> keys = rb.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String value = rb.getString(key);
                    properties.put(key, value);
                }
            }
        }
        catch (MissingResourceException e) {
            properties = null;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAsResource(String propertiesFileName) {
        Properties properties = null;
        if (propertiesFileName.startsWith("/")) {
            propertiesFileName = propertiesFileName.substring(1);
        }
        if (propertiesFileName.endsWith(PROPERTIES_FILE_SUFFIX)) {
            propertiesFileName = propertiesFileName.substring(0, propertiesFileName.length() - PROPERTIES_FILE_SUFFIX.length());
        }
        if (!(propertiesFileName = propertiesFileName.replace('.', '/')).endsWith(PROPERTIES_FILE_SUFFIX)) {
            propertiesFileName = propertiesFileName.concat(PROPERTIES_FILE_SUFFIX);
        }
        InputStream is = null;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            is = loader.getResourceAsStream(propertiesFileName);
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        }
        catch (IOException e) {
            properties = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return properties;
    }

    public static Properties load(String propertiesFileName) {
        Properties properties = PerforceProperties.loadAsFile(propertiesFileName);
        if (properties == null) {
            properties = PerforceProperties.loadAsResource(propertiesFileName);
        }
        if (properties == null) {
            properties = PerforceProperties.loadAsResourceBundle(propertiesFileName);
        }
        return properties;
    }
}

