/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.PerforceMessages;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerforceTask
extends Task {
    protected List<Field> fields = Collections.synchronizedList(new LinkedList());
    protected List<File> fileList = Collections.synchronizedList(new LinkedList());
    private List<FileSet> fileSets = Collections.synchronizedList(new LinkedList());
    protected PerforceMessages p4Messages;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String LINE_PADDING = "    ";
    protected static final String FILE_TOKEN_REGEX_PATTERN = "[^\\s\"']+|\"([^\"]*)\"|'([^']*)'";
    protected String protocol = "p4java";
    protected String port;
    protected String client;
    protected String user;
    protected String passwd;
    protected String charset;
    protected String files;
    protected boolean failOnError = true;
    protected List<IFileSpec> fileSpecs;
    protected List<IFileSpec> retFileSpecs;
    protected String retStatusMessage;

    public Field createField() {
        Field field = new Field();
        this.fields.add(field);
        return field;
    }

    public File createFile() {
        File file = new File();
        this.fileList.add(file);
        return file;
    }

    public void addFileset(FileSet fileSet) {
        if (fileSet != null) {
            this.fileSets.add(fileSet);
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setFiles(String files) {
        this.files = files;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public List<IFileSpec> getFileSpecs() {
        return this.fileSpecs;
    }

    public List<IFileSpec> getRetFileSpecs() {
        return this.retFileSpecs;
    }

    public String getRetStatusMessage() {
        return this.retStatusMessage;
    }

    public void init() {
        this.initEnv();
    }

    private void initEnv() {
        if (this.isEmpty(this.port)) {
            this.port = this.getProject().getProperty("p4.port");
            if (this.isEmpty(this.port)) {
                this.port = System.getenv("P4PORT");
            }
        }
        if (this.isEmpty(this.user)) {
            this.user = this.getProject().getProperty("p4.user");
            if (this.isEmpty(this.user)) {
                this.user = System.getenv("P4USER");
            }
        }
        if (this.isEmpty(this.passwd)) {
            this.passwd = this.getProject().getProperty("p4.passwd");
            if (this.isEmpty(this.passwd)) {
                this.passwd = System.getenv("P4PASSWD");
            }
        }
        if (this.isEmpty(this.client)) {
            this.client = this.getProject().getProperty("p4.client");
            if (this.isEmpty(this.client)) {
                this.client = System.getenv("P4CLIENT");
            }
        }
        if (this.isEmpty(this.charset)) {
            this.charset = this.getProject().getProperty("p4.charset");
            if (this.isEmpty(this.charset)) {
                this.charset = System.getenv("P4CHARSET");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.p4Messages = new PerforceMessages();
        if (this.isEmpty(this.port)) {
            throw new BuildException(this.p4Messages.getMessage("p4.port.attribute.exception"));
        }
        if (this.isEmpty(this.user)) {
            throw new BuildException(this.p4Messages.getMessage("p4.user.attribute.exception"));
        }
        if (this.isEmpty(this.client)) {
            throw new BuildException(this.p4Messages.getMessage("p4.client.attribute.exception"));
        }
        try {
            this.initP4();
            this.execP4Command();
        }
        catch (Exception e) {
            String failMsg = this.p4Messages.getMessage("project.task.failed", new Object[]{e.getLocalizedMessage()});
            if (this.failOnError) {
                if (e instanceof BuildException) {
                    throw new BuildException((Throwable)e);
                }
                throw new BuildException(failMsg, (Throwable)e);
            }
            this.log(failMsg, 0);
        }
        finally {
            try {
                this.cleanupP4();
            }
            catch (Exception e) {
                this.log(e.getLocalizedMessage(), 1);
            }
        }
        this.log(this.p4Messages.getMessage("project.task.completed", new Object[]{this.getProject().getName()}), 2);
    }

    protected abstract void initP4() throws BuildException;

    protected abstract void cleanupP4() throws BuildException;

    protected abstract void execP4Command() throws BuildException;

    protected void logFileSpecs(List<IFileSpec> fileSpecs) {
        if (fileSpecs != null) {
            for (IFileSpec fileSpec : fileSpecs) {
                this.logFileSpec(fileSpec);
            }
        }
    }

    protected void logFileSpec(IFileSpec fileSpec) {
        if (fileSpec != null) {
            int messagePriority = 2;
            StringBuilder message = new StringBuilder();
            message.append("fileSpec {" + LINE_SEPARATOR);
            if (fileSpec.toString() != null) {
                message.append(LINE_PADDING).append("fileSpec").append("=").append(fileSpec.toString()).append(LINE_SEPARATOR);
            }
            if (fileSpec.getOpStatus() != null) {
                message.append(LINE_PADDING).append("opStatus").append("=").append(fileSpec.getOpStatus()).append(LINE_SEPARATOR);
            }
            if (fileSpec.getStatusMessage() != null) {
                message.append(LINE_PADDING).append("statusMessage").append("=").append(fileSpec.getStatusMessage()).append(LINE_SEPARATOR);
            }
            if (fileSpec.getDepotPath() != null) {
                message.append(LINE_PADDING).append("depotPath").append("=").append(fileSpec.getDepotPath()).append(LINE_SEPARATOR);
            }
            if (fileSpec.getEndRevision() >= 0) {
                message.append(LINE_PADDING).append("endRevision").append("=").append(fileSpec.getEndRevision()).append(LINE_SEPARATOR);
            }
            if (fileSpec.getChangelistId() >= 0) {
                message.append(LINE_PADDING).append("changelistId").append("=").append(fileSpec.getChangelistId()).append(LINE_SEPARATOR);
            }
            if (fileSpec.getAction() != null) {
                message.append(LINE_PADDING).append("action").append("=").append(fileSpec.getAction()).append(LINE_SEPARATOR);
            }
            if (fileSpec.getFileType() != null) {
                message.append(LINE_PADDING).append("fileType").append("=").append(fileSpec.getFileType()).append(LINE_SEPARATOR);
            }
            if (fileSpec.getDate() != null) {
                message.append(LINE_PADDING).append("date").append("=").append(fileSpec.getDate()).append(LINE_SEPARATOR);
            }
            message.append("}" + LINE_SEPARATOR);
            switch (fileSpec.getOpStatus()) {
                case UNKNOWN: {
                    messagePriority = 1;
                    break;
                }
                case VALID: {
                    messagePriority = 2;
                    break;
                }
                case INFO: {
                    messagePriority = 2;
                    break;
                }
                case CLIENT_ERROR: {
                    messagePriority = 0;
                    break;
                }
                case ERROR: {
                    messagePriority = 0;
                    break;
                }
                default: {
                    messagePriority = 2;
                }
            }
            this.log(message.toString(), messagePriority);
        }
    }

    protected void logExtendedFileSpecs(List<IExtendedFileSpec> extendedFileSpecs) {
        if (extendedFileSpecs != null) {
            for (IExtendedFileSpec extendedFileSpec : extendedFileSpecs) {
                this.logExtendedFileSpec(extendedFileSpec);
            }
        }
    }

    protected void logExtendedFileSpec(IExtendedFileSpec extendedFileSpec) {
        this.logFileSpec((IFileSpec)extendedFileSpec);
    }

    protected void logFileDiffs(List<IFileDiff> fileDiffs) {
        if (fileDiffs != null) {
            for (IFileDiff fileDiff : fileDiffs) {
                this.logFileDiff(fileDiff);
            }
        }
    }

    protected void logFileDiff(IFileDiff fileDiff) {
        if (fileDiff != null) {
            int messagePriority = 2;
            StringBuilder message = new StringBuilder();
            message.append("fileDiff {" + LINE_SEPARATOR);
            message.append(LINE_PADDING).append("status").append("=").append(fileDiff.getStatus()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("fileType1").append("=").append(fileDiff.getFileType1()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("depotFile1").append("=").append(fileDiff.getDepotFile1()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("revision1").append("=").append(fileDiff.getRevision1()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("fileType2").append("=").append(fileDiff.getFileType2()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("depotFile2").append("=").append(fileDiff.getDepotFile2()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("revision2").append("=").append(fileDiff.getRevision2()).append(LINE_SEPARATOR);
            message.append("}" + LINE_SEPARATOR);
            switch (fileDiff.getStatus()) {
                case LEFT_ONLY: {
                    messagePriority = 2;
                    break;
                }
                case RIGHT_ONLY: {
                    messagePriority = 2;
                    break;
                }
                case CONTENT: {
                    messagePriority = 2;
                    break;
                }
                case IDENTICAL: {
                    messagePriority = 2;
                    break;
                }
                default: {
                    messagePriority = 2;
                }
            }
            this.log(message.toString(), messagePriority);
        }
    }

    protected void logChangelistSummaries(List<IChangelistSummary> changelistSummaries) {
        if (changelistSummaries != null) {
            for (IChangelistSummary changelistSummary : changelistSummaries) {
                this.logChangelistSummary(changelistSummary);
            }
        }
    }

    protected void logChangelistSummary(IChangelistSummary changelistSummary) {
        if (changelistSummary != null) {
            int messagePriority = 2;
            StringBuilder message = new StringBuilder();
            message.append("changelistSummary {" + LINE_SEPARATOR);
            message.append(LINE_PADDING).append("status").append("=").append(changelistSummary.getStatus()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("id").append("=").append(changelistSummary.getId()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("description").append("=").append(changelistSummary.getDescription()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("username").append("=").append(changelistSummary.getUsername()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("date").append("=").append(changelistSummary.getDate()).append(LINE_SEPARATOR);
            message.append("}" + LINE_SEPARATOR);
            this.log(message.toString(), messagePriority);
        }
    }

    protected void logFixes(List<IFix> fixes) {
        if (fixes != null) {
            for (IFix fix : fixes) {
                this.logFix(fix);
            }
        }
    }

    protected void logFix(IFix fix) {
        if (fix != null) {
            int messagePriority = 2;
            StringBuilder message = new StringBuilder();
            message.append("fix {" + LINE_SEPARATOR);
            message.append(LINE_PADDING).append("status").append("=").append(fix.getStatus()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("action").append("=").append(fix.getAction()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("date").append("=").append(fix.getDate()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("jobId").append("=").append(fix.getJobId()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("changelistId").append("=").append(fix.getChangelistId()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("clientName").append("=").append(fix.getClientName()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("userName").append("=").append(fix.getUserName()).append(LINE_SEPARATOR);
            message.append("}" + LINE_SEPARATOR);
            this.log(message.toString(), messagePriority);
        }
    }

    protected void logFileLineMatches(List<IFileLineMatch> fileLineMatches) {
        if (fileLineMatches != null) {
            for (IFileLineMatch fileLineMatch : fileLineMatches) {
                this.logFileLineMatch(fileLineMatch);
            }
        }
    }

    protected void logFileLineMatch(IFileLineMatch fileLineMatch) {
        if (fileLineMatch != null) {
            int messagePriority = 2;
            StringBuilder message = new StringBuilder();
            message.append("fileLineMatch {" + LINE_SEPARATOR);
            message.append(LINE_PADDING).append("type").append("=").append(fileLineMatch.getType()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("depotFile").append("=").append(fileLineMatch.getDepotFile()).append(LINE_SEPARATOR);
            message.append(LINE_PADDING).append("revision").append("=").append(fileLineMatch.getRevision()).append(LINE_SEPARATOR);
            if (fileLineMatch.getLineNumber() > 0) {
                message.append(LINE_PADDING).append("lineNumber").append("=").append(fileLineMatch.getLineNumber()).append(LINE_SEPARATOR);
            }
            message.append(LINE_PADDING).append("line").append("=").append(fileLineMatch.getLine()).append(LINE_SEPARATOR);
            message.append("}" + LINE_SEPARATOR);
            this.log(message.toString(), messagePriority);
        }
    }

    protected void logJobs(List<IJob> jobs) {
        if (jobs != null) {
            for (IJob job : jobs) {
                this.logJob(job);
            }
        }
    }

    protected void logJob(IJob job) {
        if (job != null) {
            int messagePriority = 2;
            StringBuilder message = new StringBuilder();
            message.append("job {" + LINE_SEPARATOR);
            Map rawFields = job.getRawFields();
            if (rawFields != null) {
                for (Map.Entry entry : rawFields.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    message.append(LINE_PADDING).append(key).append("=").append(value != null ? value : "").append(LINE_SEPARATOR);
                }
            }
            message.append("}" + LINE_SEPARATOR);
            this.log(message.toString(), messagePriority);
        }
    }

    protected Map<String, String> getFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : this.fields) {
            map.put(field.getName(), field.getValue());
        }
        return map;
    }

    protected String[] getFiles() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.files != null) {
            Pattern pattern = Pattern.compile(FILE_TOKEN_REGEX_PATTERN);
            Matcher regexMatcher = pattern.matcher(this.files);
            while (regexMatcher.find()) {
                if (regexMatcher.groupCount() <= 0) continue;
                if (regexMatcher.group(1) != null) {
                    list.add(regexMatcher.group(1));
                    continue;
                }
                if (regexMatcher.group(2) != null) {
                    list.add(regexMatcher.group(2));
                    continue;
                }
                list.add(regexMatcher.group());
            }
        }
        for (File file : this.fileList) {
            list.add(file.getPath());
        }
        for (FileSet fs : this.fileSets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            if (srcFiles == null) continue;
            for (int j = 0; j < srcFiles.length; ++j) {
                java.io.File f = new java.io.File(ds.getBasedir(), srcFiles[j]);
                list.add(f.getAbsolutePath());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    protected int parseChangelist(String changelist) {
        if (!this.isEmpty(changelist)) {
            if (changelist.trim().equalsIgnoreCase("default")) {
                return 0;
            }
            try {
                int changelistId = Integer.parseInt(changelist);
                if (changelistId < 0) {
                    return -1;
                }
                return changelistId;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public class File {
        private String path;

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class Field {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

