/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import org.apache.tools.ant.BuildException;

public class ResolveTask
extends ClientTask {
    protected boolean safeMerge = false;
    protected boolean acceptTheirs = false;
    protected boolean acceptYours = false;
    protected boolean showActionsOnly = false;
    protected boolean forceResolve = false;

    public ResolveTask() {
        this.commandOptions = new ResolveFilesAutoOptions(this.showActionsOnly, this.safeMerge, this.acceptTheirs, this.acceptYours, this.forceResolve);
    }

    public void setSafeMerge(boolean safeMerge) {
        ((ResolveFilesAutoOptions)this.commandOptions).setSafeMerge(safeMerge);
    }

    public void setAcceptTheirs(boolean acceptTheirs) {
        ((ResolveFilesAutoOptions)this.commandOptions).setAcceptTheirs(acceptTheirs);
    }

    public void setAcceptYours(boolean acceptYours) {
        ((ResolveFilesAutoOptions)this.commandOptions).setAcceptYours(acceptYours);
    }

    public void setShowActionsOnly(boolean showActionsOnly) {
        ((ResolveFilesAutoOptions)this.commandOptions).setShowActionsOnly(showActionsOnly);
    }

    public void setForceResolve(boolean forceResolve) {
        ((ResolveFilesAutoOptions)this.commandOptions).setForceResolve(forceResolve);
    }

    protected void execP4Command() throws BuildException {
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.retFileSpecs = this.getP4Client().resolveFilesAuto(this.fileSpecs, (ResolveFilesAutoOptions)this.commandOptions);
            this.logFileSpecs(this.retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

