/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.RevertFilesOptions;
import org.apache.tools.ant.BuildException;

public class RevertTask
extends ClientTask {
    protected boolean noUpdate = false;
    protected String changelist = String.valueOf(-1);
    protected boolean revertOnlyUnchanged = false;
    protected boolean noClientRefresh = false;

    public RevertTask() {
        this.commandOptions = new RevertFilesOptions(this.noUpdate, this.parseChangelist(this.changelist), this.revertOnlyUnchanged, this.noClientRefresh);
    }

    public void setChangelist(String changelist) {
        ((RevertFilesOptions)this.commandOptions).setChangelistId(this.parseChangelist(changelist));
    }

    public void setNoUpdate(boolean noUpdate) {
        ((RevertFilesOptions)this.commandOptions).setNoUpdate(noUpdate);
    }

    public void setRevertOnlyUnchanged(boolean revertOnlyUnchanged) {
        ((RevertFilesOptions)this.commandOptions).setRevertOnlyUnchanged(revertOnlyUnchanged);
    }

    public void setNoClientRefresh(boolean noClientRefresh) {
        ((RevertFilesOptions)this.commandOptions).setNoClientRefresh(noClientRefresh);
    }

    protected void execP4Command() throws BuildException {
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.retFileSpecs = this.getP4Client().revertFiles(this.fileSpecs, (RevertFilesOptions)this.commandOptions);
            this.logFileSpecs(this.retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

