/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.PerforceProperties;
import com.perforce.p4java.ant.tasks.PerforceTask;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.RpcSystemFileCommandsHelper;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.option.server.LoginOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.ServerFactory;
import com.perforce.p4java.server.callback.ICommandCallback;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public abstract class ServerTask
extends PerforceTask {
    protected List<GlobalOption> globaloptions = Collections.synchronizedList(new LinkedList());
    public static final String P4_SERVER_PROTOCOL_PROPERTIES_FILE = "com.perforce.p4java.ant.tasks.P4ServerProtocol";
    public static final String P4_SERVER_USAGE_PROPERTIES_FILE = "com.perforce.p4java.ant.tasks.P4ServerUsage";
    protected IOptionsServer p4Server;
    protected String protocolPropertiesFile = "com.perforce.p4java.ant.tasks.P4ServerProtocol";
    protected String usagePropertiesFile = "com.perforce.p4java.ant.tasks.P4ServerUsage";
    protected Properties protocolProps = null;
    protected Properties usageProps = null;
    protected String programName = null;
    protected String programVersion = null;
    protected String workingDirectory = null;
    protected String hostName = null;
    protected String textLanguage = null;
    protected String unsetUserName = null;
    protected String unsetClientName = null;
    private UsageOptions usageOptions;
    protected boolean allHosts = false;
    private LoginOptions loginOptions = new LoginOptions(this.allHosts);
    protected Options commandOptions;

    public GlobalOption createGlobalOption() {
        GlobalOption globaloption = new GlobalOption();
        this.globaloptions.add(globaloption);
        return globaloption;
    }

    public ServerTask() {
        this.usageOptions = new UsageOptions(null);
    }

    public IOptionsServer getP4Server() {
        return this.p4Server;
    }

    public void setP4Server(IOptionsServer p4Server) {
        this.p4Server = p4Server;
    }

    public void setProtocolPropertiesFile(String protocolPropertiesFile) {
        this.protocolPropertiesFile = protocolPropertiesFile;
    }

    public void setUsagePropertiesFile(String usagePropertiesFile) {
        this.usagePropertiesFile = usagePropertiesFile;
    }

    public void setProtocolProps(Properties protocolProps) {
        this.protocolProps = protocolProps;
    }

    public void setUsageProps(Properties usageProps) {
        this.usageOptions.setProps(usageProps);
    }

    public void setProgramName(String programName) {
        this.usageOptions.setProgramName(programName);
    }

    public void setProgramVersion(String programVersion) {
        this.usageOptions.setProgramVersion(programVersion);
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.usageOptions.setWorkingDirectory(workingDirectory);
    }

    public void setHostName(String hostName) {
        this.usageOptions.setHostName(hostName);
    }

    public void setTextLanguage(String textLanguage) {
        this.usageOptions.setTextLanguage(textLanguage);
    }

    public void setUnsetUserName(String unsetUserName) {
        this.usageOptions.setUnsetUserName(unsetUserName);
    }

    public void setUnsetClientName(String unsetClientName) {
        this.usageOptions.setUnsetClientName(unsetClientName);
    }

    public void setAllHosts(boolean allHosts) {
        this.loginOptions.setAllHosts(allHosts);
    }

    protected void initP4Server() {
        try {
            this.initP4ServerOptions();
            ServerFactory.setRpcFileSystemHelper((ISystemFileCommandsHelper)new RpcSystemFileCommandsHelper());
            this.p4Server = ServerFactory.getOptionsServer((String)(this.protocol + "://" + this.port), (Properties)this.protocolProps, (UsageOptions)this.usageOptions);
            this.p4Server.registerCallback(new ICommandCallback(){

                public void receivedServerMessage(int key, int genericCode, int severityCode, String message) {
                    if (severityCode == 2) {
                        int messagePriority = 1;
                        StringBuilder sb = new StringBuilder();
                        sb.append("receivedServerMessage {" + PerforceTask.LINE_SEPARATOR);
                        sb.append("    ").append("genericCode").append("=").append(genericCode).append(PerforceTask.LINE_SEPARATOR);
                        sb.append("    ").append("severityCode").append("=").append(severityCode).append(PerforceTask.LINE_SEPARATOR);
                        sb.append("    ").append("message").append("=").append(message).append(PerforceTask.LINE_SEPARATOR);
                        sb.append("}" + PerforceTask.LINE_SEPARATOR);
                        ServerTask.this.log(sb.toString(), messagePriority);
                    }
                }

                public void receivedServerInfoLine(int key, String infoLine) {
                    int messagePriority = 2;
                    StringBuilder sb = new StringBuilder();
                    sb.append("receivedServerInfoLine {" + PerforceTask.LINE_SEPARATOR);
                    sb.append("    ").append("infoLine").append("=").append(infoLine).append(PerforceTask.LINE_SEPARATOR);
                    sb.append("}" + PerforceTask.LINE_SEPARATOR);
                    ServerTask.this.log(sb.toString(), messagePriority);
                }

                public void receivedServerErrorLine(int key, String errorLine) {
                    int messagePriority = 0;
                    StringBuilder sb = new StringBuilder();
                    sb.append("receivedServerErrorLine {" + PerforceTask.LINE_SEPARATOR);
                    sb.append("    ").append("errorLine").append("=").append(errorLine).append(PerforceTask.LINE_SEPARATOR);
                    sb.append("}" + PerforceTask.LINE_SEPARATOR);
                    ServerTask.this.log(sb.toString(), messagePriority);
                }

                public void issuingServerCommand(int key, String command) {
                    int messagePriority = 2;
                    StringBuilder sb = new StringBuilder();
                    sb.append("issuingServerCommand {" + PerforceTask.LINE_SEPARATOR);
                    sb.append("    ").append("key").append("=").append(key).append(PerforceTask.LINE_SEPARATOR);
                    sb.append("    ").append("command").append("=").append(command).append(PerforceTask.LINE_SEPARATOR);
                    sb.append("}" + PerforceTask.LINE_SEPARATOR);
                    ServerTask.this.log(sb.toString(), messagePriority);
                }

                public void completedServerCommand(int key, long millisecsTaken) {
                    int messagePriority = 2;
                    StringBuilder sb = new StringBuilder();
                    sb.append("completedServerCommand {" + PerforceTask.LINE_SEPARATOR);
                    sb.append("    ").append("key").append("=").append(key).append(PerforceTask.LINE_SEPARATOR);
                    sb.append("    ").append("millisecsTaken").append("=").append(millisecsTaken).append(PerforceTask.LINE_SEPARATOR);
                    sb.append("}" + PerforceTask.LINE_SEPARATOR);
                    ServerTask.this.log(sb.toString(), messagePriority);
                }
            });
            this.p4Server.connect();
            if (!this.isEmpty(this.charset) && this.p4Server.isConnected() && this.p4Server.supportsUnicode()) {
                this.p4Server.setCharsetName(this.charset);
            }
            if (!this.isEmpty(this.user)) {
                this.p4Server.setUserName(this.user);
                this.p4Server.login(this.passwd, this.loginOptions);
            }
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }

    protected void initP4ServerOptions() {
        this.protocolProps = PerforceProperties.load(this.protocolPropertiesFile);
        this.setProtocolProps(this.protocolProps);
        this.usageProps = PerforceProperties.load(this.usagePropertiesFile);
        Properties globalProps = this.getGlobalOptions();
        if (globalProps != null) {
            if (this.usageProps == null) {
                this.usageProps = new Properties();
            }
            this.usageProps.putAll((Map<?, ?>)globalProps);
            if (this.protocolProps == null) {
                this.protocolProps = new Properties();
            }
            this.protocolProps.putAll((Map<?, ?>)globalProps);
            String globalClient = globalProps.getProperty("clientName", globalProps.getProperty("com.perforce.p4java.clientName", null));
            String globalUser = globalProps.getProperty("userName", globalProps.getProperty("com.perforce.p4java.userName", null));
            String globalPasswd = globalProps.getProperty("password", globalProps.getProperty("com.perforce.p4java.password", null));
            if (!this.isEmpty(globalClient)) {
                this.client = globalClient;
            }
            if (!this.isEmpty(globalUser)) {
                this.user = globalUser;
            }
            if (!this.isEmpty(globalPasswd)) {
                this.passwd = globalPasswd;
            }
        }
        this.setUsageProps(this.usageProps);
    }

    protected void cleanupP4Server() {
        try {
            this.p4Server.disconnect();
            this.p4Server = null;
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }

    protected void initP4() throws BuildException {
        this.initP4Server();
    }

    protected void cleanupP4() throws BuildException {
        this.cleanupP4Server();
    }

    protected Properties getGlobalOptions() {
        Properties properties = new Properties();
        for (GlobalOption globaloption : this.globaloptions) {
            properties.put(globaloption.getKey(), globaloption.getValue());
        }
        return properties;
    }

    public class GlobalOption {
        private String key;
        private String value;

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

