/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.ShelveFilesOptions;
import org.apache.tools.ant.BuildException;

public class ShelveTask
extends ClientTask {
    protected String changelist = String.valueOf(-1);
    protected boolean forceShelve = false;
    protected boolean replaceFiles = false;
    protected boolean deleteFiles = false;

    public ShelveTask() {
        this.commandOptions = new ShelveFilesOptions(this.forceShelve, this.replaceFiles, this.deleteFiles);
    }

    public void setChangelist(String changelist) {
        this.changelist = changelist;
    }

    public void setForceShelve(boolean forceShelve) {
        ((ShelveFilesOptions)this.commandOptions).setForceShelve(forceShelve);
    }

    public void setReplaceFiles(boolean replaceFiles) {
        ((ShelveFilesOptions)this.commandOptions).setReplaceFiles(replaceFiles);
    }

    public void setDeleteFiles(boolean deleteFiles) {
        ((ShelveFilesOptions)this.commandOptions).setDeleteFiles(deleteFiles);
    }

    protected void execP4Command() throws BuildException {
        if (this.parseChangelist(this.changelist) == 0 || this.parseChangelist(this.changelist) == -1) {
            throw new BuildException("Must specify a changelist; it cannot be default or unknown.");
        }
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.retFileSpecs = this.getP4Client().shelveFiles(this.fileSpecs, this.parseChangelist(this.changelist), (ShelveFilesOptions)this.commandOptions);
            this.logFileSpecs(this.retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

