/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.changelist.SubmitOptions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitTask
extends ClientTask {
    protected String changelist = String.valueOf(0);
    protected String changelistDescription;
    protected String changelistProperty;
    protected String needsResolveProperty;
    protected boolean reOpen = false;
    protected String jobs;
    protected String jobStatus;

    public SubmitTask() {
        this.commandOptions = new SubmitOptions(this.reOpen, null, this.jobStatus);
    }

    public void setChangelist(String changelist) {
        this.changelist = changelist;
    }

    public void setChangelistDescription(String changelistDescription) {
        this.changelistDescription = changelistDescription;
    }

    public void setChangelistProperty(String changelistProperty) {
        this.changelistProperty = changelistProperty;
    }

    public void setNeedsResolveProperty(String needsResolveProperty) {
        this.needsResolveProperty = needsResolveProperty;
    }

    public void setReOpen(boolean reOpen) {
        ((SubmitOptions)this.commandOptions).setReOpen(reOpen);
    }

    public void setJobs(String jobs) {
        ((SubmitOptions)this.commandOptions).setJobIds(this.getJobs(jobs));
    }

    public void setJobStatus(String jobStatus) {
        ((SubmitOptions)this.commandOptions).setJobStatus(jobStatus);
    }

    @Override
    protected void execP4Command() throws BuildException {
        try {
            IChangelist change = this.getP4Server().getChangelist(this.parseChangelist(this.changelist));
            if (change.canRefresh() && change.getId() != -1) {
                change.refresh();
            }
            if (!this.isEmpty(this.changelistDescription)) {
                change.setDescription(this.changelistDescription);
                if (change.canUpdate() && change.getId() != 0 && change.getId() != -1) {
                    change.update();
                }
            }
            this.retFileSpecs = change.submit((SubmitOptions)this.commandOptions);
            this.getProject().setProperty("p4.changelist", "" + change.getId());
            if (!this.isEmpty(this.changelistProperty)) {
                this.getProject().setNewProperty(this.changelistProperty, String.valueOf(change.getId()));
            }
            this.handleMessage(this.retFileSpecs);
            this.logFileSpecs(this.retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }

    protected LinkedList<String> getJobs(String jobs) {
        String[] tokens;
        if (jobs != null && (tokens = jobs.trim().split("\\s+")) != null && tokens.length > 0) {
            return new LinkedList<String>(Arrays.asList(tokens));
        }
        return null;
    }

    protected void handleMessage(List<IFileSpec> fileSpecList) {
        String MUST_RESOLVE_PATTERN = "must resolve";
        this.getProject().setProperty("p4.needsresolve", "0");
        if (fileSpecList != null) {
            boolean found = false;
            for (IFileSpec fileSpec : fileSpecList) {
                if (fileSpec != null) {
                    switch (fileSpec.getOpStatus()) {
                        case INFO: {
                            if (!fileSpec.getStatusMessage().contains("must resolve")) break;
                            this.getProject().setProperty("p4.needsresolve", "1");
                            if (this.needsResolveProperty != null) {
                                this.getProject().setNewProperty(this.needsResolveProperty, "true");
                            }
                            found = true;
                            break;
                        }
                    }
                }
                if (!found) continue;
                break;
            }
        }
    }
}

