/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.ant.tasks;

import com.perforce.p4java.ant.tasks.ClientTask;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.TagFilesOptions;
import org.apache.tools.ant.BuildException;

public class TagTask
extends ClientTask {
    protected boolean listOnly = false;
    protected boolean delete = false;
    protected String label;

    public TagTask() {
        this.commandOptions = new TagFilesOptions(this.listOnly, this.delete);
    }

    public void setListOnly(boolean listOnly) {
        ((TagFilesOptions)this.commandOptions).setListOnly(listOnly);
    }

    public void setDelete(boolean delete) {
        ((TagFilesOptions)this.commandOptions).setDelete(delete);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    protected void execP4Command() throws BuildException {
        if (this.isEmpty(this.label)) {
            throw new BuildException("No label name specified.");
        }
        try {
            this.fileSpecs = FileSpecBuilder.makeFileSpecList((String[])this.getFiles());
            this.retFileSpecs = this.getP4Server().tagFiles(this.fileSpecs, this.label, (TagFilesOptions)this.commandOptions);
            this.logFileSpecs(this.retFileSpecs);
        }
        catch (P4JavaException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (P4JavaError e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e, this.getLocation());
        }
        catch (Throwable t) {
            throw new BuildException(t.getLocalizedMessage(), t, this.getLocation());
        }
    }
}

