/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.admin;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfigurationValue {
    public static final String ALL_SERVERS = "allservers";
    private String serverName = null;
    private ConfigType type = ConfigType.UNKNOWN;
    private String name = null;
    private String value = null;

    public ServerConfigurationValue() {
    }

    public ServerConfigurationValue(String serverName, ConfigType type, String name, String value) {
        this.serverName = serverName;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public ServerConfigurationValue(String serverName, String type, String name, String value) {
        this.serverName = serverName;
        this.type = ConfigType.fromString(type);
        this.name = name;
        this.value = value;
    }

    public ServerConfigurationValue(Map<String, Object> map) {
        if (map != null) {
            this.name = (String)map.get("Name");
            this.value = (String)map.get("Value");
            this.serverName = (String)map.get("ServerName");
            this.type = ConfigType.fromString((String)map.get("Type"));
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public ServerConfigurationValue setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public ConfigType getType() {
        return this.type;
    }

    public ServerConfigurationValue setType(ConfigType type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ServerConfigurationValue setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ServerConfigurationValue setValue(String value) {
        this.value = value;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigType {
        UNKNOWN,
        OPTION,
        ENVIRONMENT,
        TUNABLE,
        CONFIGURE;


        public static ConfigType fromString(String str) {
            if (str != null) {
                for (ConfigType configType : ConfigType.values()) {
                    if (!configType.toString().equalsIgnoreCase(str)) continue;
                    return configType;
                }
            }
            return UNKNOWN;
        }
    }
}

