/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.Log;
import com.perforce.p4java.env.SystemInfo;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.StringHelper;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.TextNormalizationHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.UnicodeHelper;
import com.perforce.p4java.impl.mapbased.server.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RpcPerforceFileType {
    FST_TEXT,
    FST_BINARY,
    FST_GZIP,
    FST_DIRECTORY,
    FST_SYMLINK,
    FST_RESOURCE,
    FST_SPECIAL,
    FST_MISSING,
    FST_CANTTELL,
    FST_EMPTY,
    FST_UNICODE,
    FST_GUNZIP,
    FST_UTF8,
    FST_UTF16,
    FST_ATEXT,
    FST_XTEXT,
    FST_RTEXT,
    FST_RXTEXT,
    FST_CBINARY,
    FST_XBINARY,
    FST_XSYMLINK,
    FST_XRESOURCE,
    FST_APPLETEXT,
    FST_APPLEFILE,
    FST_XAPPLEFILE,
    FST_XAPPLETEXT,
    FST_XUNICODE,
    FST_XRTEXT,
    FST_XUTF8,
    FST_XUTF16,
    FST_XGUNZIP,
    FST_RCS;

    public static final String TRACE_PREFIX = "RpcPerforceFileType";
    private static final ISystemFileCommandsHelper fileCommands;
    private static CtAction symlinkAction;
    private static ActionTableElement[] actionTable;
    private static final byte[] pdfMagic;
    private static final byte[][] cBinaryMagicTable;

    public static RpcPerforceFileType decodeFromServerString(String str) {
        if (str == null) {
            return FST_TEXT;
        }
        int tf = 0;
        int tl = 0;
        int tu = 0;
        switch (str.length()) {
            default: {
                tu = StringHelper.hexcharToInt(str.charAt(2));
            }
            case 2: {
                tl = StringHelper.hexcharToInt(str.charAt(1));
            }
            case 1: {
                tf = StringHelper.hexcharToInt(str.charAt(0));
            }
            case 0: 
        }
        switch (tu << 8 | tf) {
            case 0: {
                return FST_TEXT;
            }
            case 1: {
                return FST_BINARY;
            }
            case 2: {
                return FST_XTEXT;
            }
            case 3: {
                return FST_XBINARY;
            }
            case 4: {
                return FST_SYMLINK;
            }
            case 5: {
                return FST_RESOURCE;
            }
            case 6: {
                return FST_XSYMLINK;
            }
            case 7: {
                return FST_XRESOURCE;
            }
            case 8: {
                return FST_UNICODE;
            }
            case 9: {
                return FST_RTEXT;
            }
            case 10: {
                return FST_XUNICODE;
            }
            case 11: {
                return FST_XRTEXT;
            }
            case 12: {
                return FST_APPLETEXT;
            }
            case 13: {
                return FST_APPLEFILE;
            }
            case 14: {
                return FST_XAPPLETEXT;
            }
            case 15: {
                return FST_XAPPLEFILE;
            }
            case 20: {
                return FST_UTF8;
            }
            case 22: {
                return FST_XUTF8;
            }
            case 24: {
                return FST_UTF16;
            }
            case 26: {
                return FST_XUTF16;
            }
            case 257: {
                return FST_GUNZIP;
            }
            case 259: {
                return FST_XGUNZIP;
            }
        }
        return FST_BINARY;
    }

    public boolean isExecutable() {
        switch (this) {
            case FST_XTEXT: 
            case FST_XAPPLEFILE: 
            case FST_XBINARY: 
            case FST_XUNICODE: 
            case FST_XUTF8: 
            case FST_XUTF16: 
            case FST_XGUNZIP: {
                return true;
            }
        }
        return false;
    }

    public static RpcPerforceFileType inferFileType(File file, boolean isUnicodeServer, Charset clientCharset) {
        if (file == null) {
            throw new NullPointerError("Null file handle passed to RpcPerforceFileType.inferFileType()");
        }
        try {
            if (RpcPerforceFileType.isProbablySymLink(file)) {
                return FST_SYMLINK;
            }
            if (!file.exists()) {
                return FST_MISSING;
            }
            if (file.isDirectory()) {
                return FST_DIRECTORY;
            }
            if (!file.isFile()) {
                return FST_CANTTELL;
            }
            if (file.length() == 0L) {
                return FST_EMPTY;
            }
            return RpcPerforceFileType.inferFileTypeFromContents(file, fileCommands.canExecute(file.getPath()), isUnicodeServer, clientCharset);
        }
        catch (Exception exc) {
            Log.exception(exc);
            return FST_CANTTELL;
        }
    }

    public static RpcServerTypeStringSpec getServerFileTypeString(String clientPath, RpcPerforceFileType fileType, String forceType, int xfiles) {
        if (fileType != null) {
            for (ActionTableElement atElement : actionTable) {
                if (atElement.checkType != fileType) continue;
                return RpcPerforceFileType.getAction(clientPath, xfiles, atElement, forceType);
            }
        }
        Log.error("Encountered null or unknown filetype in getServerFileTypeString()");
        return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, "unknown"}));
    }

    public static boolean isProbablySymLink(File file) {
        if (file != null) {
            if (SymbolicLinkHelper.isSymbolicLinkCapable()) {
                return SymbolicLinkHelper.isSymbolicLink(file.getPath());
            }
            ISystemFileCommandsHelper helper = SysFileHelperBridge.getSysFileCommands();
            if (helper != null && helper.isSymlink(file.getPath())) {
                return true;
            }
            if (!Server.isRunningOnWindows()) {
                try {
                    String absoPath = file.getAbsolutePath();
                    String canoPath = file.getCanonicalPath();
                    if (TextNormalizationHelper.isNormalizationCapable()) {
                        canoPath = TextNormalizationHelper.normalize(file.getCanonicalPath());
                    }
                    if (SystemInfo.isMac() ? !absoPath.equalsIgnoreCase(canoPath) : !absoPath.equals(canoPath)) {
                        return true;
                    }
                }
                catch (IOException ioexc) {
                    Log.warn("unexpected exception in RpcPerforceFileType.isProbablySymLink(): " + ioexc.getLocalizedMessage());
                    Log.exception(ioexc);
                }
            }
        }
        return false;
    }

    private static RpcServerTypeStringSpec getAction(String clientPath, int xlevel, ActionTableElement atElement, String forceType) {
        switch (atElement.ctActions[atElement.xlevel >= xlevel ? 0 : 1]) {
            case OK: {
                if (forceType != null) {
                    return new RpcServerTypeStringSpec(forceType, null);
                }
                return new RpcServerTypeStringSpec(atElement.type, null);
            }
            case ASS: {
                if (forceType != null) {
                    return new RpcServerTypeStringSpec(forceType, new RpcMessage(ClientMessage.ClientMessageId.ASSUMING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type, forceType}));
                }
                return new RpcServerTypeStringSpec(atElement.altType, new RpcMessage(ClientMessage.ClientMessageId.ASSUMING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type, atElement.altType}));
            }
            case SUBST: {
                return new RpcServerTypeStringSpec(atElement.altType, new RpcMessage(ClientMessage.ClientMessageId.SUBSTITUTING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.altType, atElement.type}));
            }
            case CANT: {
                return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type}));
            }
        }
        return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RpcPerforceFileType inferFileTypeFromContents(File file, boolean isExecutable, boolean isUnicodeServer, Charset clientCharset) {
        bytes = new byte[1024];
        inStream = null;
        bytesRead = 0;
        try {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            inStream = new FileInputStream(file);
                                            bytesRead = inStream.read(bytes);
                                            if (bytesRead >= 0) break block19;
                                            var7_7 = RpcPerforceFileType.FST_CANTTELL;
                                            var10_14 = null;
                                            if (inStream == null) return var7_7;
                                            ** GOTO lbl80
                                        }
                                        if (bytesRead != 0) break block20;
                                        var7_8 = RpcPerforceFileType.FST_EMPTY;
                                        ** GOTO lbl87
                                    }
                                    if (!RpcPerforceFileType.isPDF(bytes, bytesRead)) break block21;
                                    var7_9 = isExecutable != false ? RpcPerforceFileType.FST_XBINARY : RpcPerforceFileType.FST_BINARY;
                                    ** GOTO lbl96
                                }
                                if (!RpcPerforceFileType.isAsciiText(bytes, bytesRead)) break block22;
                                var7_10 = isExecutable != false ? RpcPerforceFileType.FST_XTEXT : RpcPerforceFileType.FST_TEXT;
                                ** GOTO lbl105
                            }
                            if (!RpcPerforceFileType.isKnownCBinary(bytes, bytesRead)) break block23;
                            var7_11 = RpcPerforceFileType.FST_CBINARY;
                            ** GOTO lbl114
                        }
                        rpcPerforceFileType = RpcPerforceFileType.inferUnicodeFileType(bytes, bytesRead, clientCharset);
                        if (rpcPerforceFileType != RpcPerforceFileType.FST_UTF16) break block24;
                        var8_38 = isExecutable != false ? RpcPerforceFileType.FST_XUTF16 : RpcPerforceFileType.FST_UTF16;
                        ** GOTO lbl123
                    }
                    if (rpcPerforceFileType != RpcPerforceFileType.FST_UTF8) break block25;
                    var8_39 = isExecutable != false ? RpcPerforceFileType.FST_XUTF8 : RpcPerforceFileType.FST_UTF8;
                    ** GOTO lbl132
                }
                if (!isUnicodeServer || rpcPerforceFileType != RpcPerforceFileType.FST_UNICODE && !RpcPerforceFileType.isProbablyUnicode(bytes, bytesRead, clientCharset)) break block26;
                var8_40 = isExecutable != false ? RpcPerforceFileType.FST_XUNICODE : RpcPerforceFileType.FST_UNICODE;
                ** GOTO lbl141
            }
            if (!RpcPerforceFileType.isProbablyBinary(bytes, bytesRead)) ** GOTO lbl159
            var8_41 = isExecutable != false ? RpcPerforceFileType.FST_XBINARY : RpcPerforceFileType.FST_BINARY;
            ** GOTO lbl150
        }
        catch (IOException ioexc) {
            Log.warn("Unexpected exception: " + ioexc.getMessage());
            Log.exception(ioexc);
            var8_42 = RpcPerforceFileType.FST_CANTTELL;
            var10_24 = null;
            if (inStream == null) return var8_42;
            try {
                inStream.close();
                return var8_42;
            }
            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var8_42;
        }
        {
            catch (Throwable var9_43) {
                var10_25 = null;
                if (inStream == null) throw var9_43;
                ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl74:
                // 1 sources

                inStream.close();
                throw var9_43;
lbl76:
                // 1 sources

                catch (IOException exc) {
                    Log.warn("unable to close input stream; exception follows...");
                    Log.exception(exc);
                }
                throw var9_43;
            }
lbl80:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl81:
            // 1 sources

            inStream.close();
            return var7_7;
lbl83:
            // 1 sources

            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var7_7;
lbl87:
            // 1 sources

            var10_15 = null;
            if (inStream == null) return var7_8;
            ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl90:
            // 1 sources

            inStream.close();
            return var7_8;
lbl92:
            // 1 sources

            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var7_8;
lbl96:
            // 1 sources

            var10_16 = null;
            if (inStream == null) return var7_9;
            ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl99:
            // 1 sources

            inStream.close();
            return var7_9;
lbl101:
            // 1 sources

            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var7_9;
lbl105:
            // 1 sources

            var10_17 = null;
            if (inStream == null) return var7_10;
            ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl108:
            // 1 sources

            inStream.close();
            return var7_10;
lbl110:
            // 1 sources

            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var7_10;
lbl114:
            // 1 sources

            var10_18 = null;
            if (inStream == null) return var7_11;
            ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl117:
            // 1 sources

            inStream.close();
            return var7_11;
lbl119:
            // 1 sources

            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var7_11;
lbl123:
            // 1 sources

            var10_19 = null;
            if (inStream == null) return var8_38;
            ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl126:
            // 1 sources

            inStream.close();
            return var8_38;
lbl128:
            // 1 sources

            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var8_38;
lbl132:
            // 1 sources

            var10_20 = null;
            if (inStream == null) return var8_39;
            ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl135:
            // 1 sources

            inStream.close();
            return var8_39;
lbl137:
            // 1 sources

            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var8_39;
lbl141:
            // 1 sources

            var10_21 = null;
            if (inStream == null) return var8_40;
            ** try [egrp 2[TRYBLOCK] [21 : 354->362)] { 
lbl144:
            // 1 sources

            inStream.close();
            return var8_40;
lbl146:
            // 1 sources

            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
            }
            return var8_40;
lbl150:
            // 1 sources

            var10_22 = null;
            if (inStream == null) return var8_41;
            try {}
            catch (IOException exc) {
                Log.warn("unable to close input stream; exception follows...");
                Log.exception(exc);
                return var8_41;
            }
            inStream.close();
            return var8_41;
lbl159:
            // 1 sources

            var10_23 = null;
            if (inStream == null) return RpcPerforceFileType.FST_TEXT;
            try {}
            catch (IOException exc) {}
            Log.warn("unable to close input stream; exception follows...");
            Log.exception(exc);
            return RpcPerforceFileType.FST_TEXT;
            inStream.close();
            return RpcPerforceFileType.FST_TEXT;
        }
    }

    private static boolean isProbablyUnicode(byte[] bytes, int bytesRead, Charset clientCharset) {
        if (bytes != null && bytesRead >= 2) {
            return UnicodeHelper.inferCharset(bytes, bytesRead, clientCharset);
        }
        return false;
    }

    private static RpcPerforceFileType inferUnicodeFileType(byte[] bytes, int bytesRead, Charset clientCharset) {
        if (bytes != null && bytesRead >= 2) {
            if (bytes.length >= 4 && bytes[0] == -2 && bytes[1] == -1 && bytes[2] == 0 && bytes[3] == 0) {
                return FST_UNICODE;
            }
            if (bytes.length >= 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
                return FST_UNICODE;
            }
            if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                return FST_UNICODE;
            }
            if (bytes.length >= 2 && bytes[0] == -1 && bytes[1] == -2) {
                return FST_UTF16;
            }
            if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
                return FST_UTF16;
            }
        }
        return FST_CANTTELL;
    }

    private static boolean isPDF(byte[] bytes, int bytesRead) {
        if (bytesRead > pdfMagic.length) {
            int i = 0;
            for (byte b : pdfMagic) {
                if (b == bytes[i++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isAsciiText(byte[] bytes, int bytesRead) {
        if (bytes == null) {
            return false;
        }
        for (int i = 0; i < bytesRead; ++i) {
            if (bytes[i] >= 7) continue;
            return false;
        }
        return true;
    }

    private static boolean isKnownCBinary(byte[] bytes, int bytesRead) {
        if (bytesRead > 0) {
            for (byte[] magicBytes : cBinaryMagicTable) {
                if (bytesRead <= magicBytes.length) continue;
                int i = 0;
                for (byte b : magicBytes) {
                    if (bytes[i] != b) break;
                    ++i;
                }
                if (i != magicBytes.length) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isProbablyBinary(byte[] bytes, int bytesRead) {
        int x = -128;
        int y = -97;
        if (bytesRead > 0) {
            for (int i = 0; i < bytesRead; ++i) {
                byte byteVal = bytes[i];
                if ((byteVal >= 7 || byteVal < 0) && (byteVal < -128 || byteVal > -97)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fileCommands = SysFileHelperBridge.getSysFileCommands();
        symlinkAction = SymbolicLinkHelper.isSymbolicLinkCapable() ? CtAction.OK : CtAction.CANT;
        actionTable = new ActionTableElement[]{new ActionTableElement(FST_TEXT, 0, CtAction.OK, CtAction.OK, "text", "text"), new ActionTableElement(FST_XTEXT, 0, CtAction.SUBST, CtAction.OK, "xtext", "text"), new ActionTableElement(FST_BINARY, 0, CtAction.OK, CtAction.OK, "binary", "binary"), new ActionTableElement(FST_XBINARY, 0, CtAction.SUBST, CtAction.OK, "xbinary", "binary"), new ActionTableElement(FST_APPLEFILE, 4, CtAction.SUBST, CtAction.OK, "apple", "binary"), new ActionTableElement(FST_XAPPLEFILE, 4, CtAction.SUBST, CtAction.OK, "apple+x", "binary"), new ActionTableElement(FST_CBINARY, 3, CtAction.SUBST, CtAction.OK, "ubinary", "binary"), new ActionTableElement(FST_SYMLINK, 1, CtAction.CANT, symlinkAction, "symlink", null), new ActionTableElement(FST_RESOURCE, 2, CtAction.CANT, CtAction.OK, "resource", null), new ActionTableElement(FST_SPECIAL, -1, CtAction.CANT, CtAction.CANT, "special", null), new ActionTableElement(FST_DIRECTORY, -1, CtAction.CANT, CtAction.CANT, "directory", null), new ActionTableElement(FST_MISSING, -1, CtAction.ASS, CtAction.ASS, "missing", "text"), new ActionTableElement(FST_CANTTELL, -1, CtAction.ASS, CtAction.ASS, "unreadable", "text"), new ActionTableElement(FST_EMPTY, -1, CtAction.ASS, CtAction.ASS, "empty", "text"), new ActionTableElement(FST_UNICODE, 5, CtAction.SUBST, CtAction.OK, "unicode", "text"), new ActionTableElement(FST_XUNICODE, 5, CtAction.SUBST, CtAction.OK, "xunicode", "text"), new ActionTableElement(FST_UTF16, 6, CtAction.SUBST, CtAction.OK, "utf16", "binary"), new ActionTableElement(FST_XUTF16, 6, CtAction.SUBST, CtAction.OK, "xutf16", "binary"), new ActionTableElement(FST_UTF8, 7, CtAction.SUBST, CtAction.OK, "utf8", "text"), new ActionTableElement(FST_XUTF8, 7, CtAction.SUBST, CtAction.OK, "xutf8", "text"), new ActionTableElement(FST_TEXT, 0, CtAction.OK, CtAction.OK, "text", "text")};
        pdfMagic = new byte[]{37, 80, 68, 70, 45};
        cBinaryMagicTable = new byte[][]{{71, 73, 70}, {-1, -40, -1, -32}, {-1, -40, -1, -31}, {31, -117}, {-1, 31}, {31, -99}, {80, 75, 3, 4}, {80, 75, 5, 6}, {-119, 80, 78, 71}, {-54, -2, -70, -66}};
    }

    private static class ActionTableElement {
        public RpcPerforceFileType checkType = null;
        public int xlevel = 0;
        public CtAction[] ctActions = new CtAction[2];
        public String type = null;
        public String altType = null;

        public ActionTableElement(RpcPerforceFileType checkType, int xlevel, CtAction ctActions0, CtAction ctActions1, String type, String altType) {
            this.checkType = checkType;
            this.xlevel = xlevel;
            this.ctActions[0] = ctActions0;
            this.ctActions[1] = ctActions1;
            this.type = type;
            this.altType = altType;
        }
    }

    public static class RpcServerTypeStringSpec {
        private String serverTypeString = null;
        private RpcMessage error = null;

        public RpcServerTypeStringSpec(String str, RpcMessage error) {
            this.serverTypeString = str;
            this.error = error;
        }

        public String getServerTypeString() {
            return this.serverTypeString;
        }

        public RpcMessage getMsg() {
            return this.error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CtAction {
        OK,
        ASS,
        SUBST,
        CANT;

    }
}

