/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.io.apple;

public final class AppleFileData {
    public static final AppleFileData EMPTY_FILE_DATA = new AppleFileData();
    private byte[] data;
    private int offset;
    private int length;

    public AppleFileData() {
        this.data = new byte[0];
        this.offset = 0;
        this.length = 0;
    }

    public AppleFileData(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    public AppleFileData(byte[] data, int offset, int length) {
        if (0 > offset || offset > data.length) {
            throw new IndexOutOfBoundsException();
        }
        if (0 > length || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getBytes() {
        byte[] data = new byte[this.length];
        System.arraycopy(this.data, this.offset, data, 0, this.length);
        return data;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }
}

