/**
 * Copyright (c) 2008 Perforce Software.  All rights reserved.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IRevisionIntegrationData;

import org.eclipse.team.core.history.IFileRevision;

/**
 * 
 * Bridge to Eclipse file revision interface for representing a remote file
 * revision. Wraps field of {@link IFileRevisionData} so plug-ins will be
 * shielded and be able to use only the {@link IFileRevision} interface if the
 * core fields are needed.
 * 
 * @author Kevin Sawicki (ksawicki@perforce.com)
 * 
 */
public interface IP4Revision extends IFileRevision, Comparable<IP4Revision> {

    /**
     * Get revision of the {@link #getRemotePath()} file
     * 
     * @return - revision
     */
    int getRevision();

    /**
     * Get changelist id of this revision
     * 
     * @return - submitted changelist id
     */
    int getChangelist();

    /**
     * Get file action of revision
     * 
     * @return - file action
     */
    FileAction getAction();

    /**
     * Get remote path of revision
     * 
     * @return - depot path syntax remote path
     */
    String getRemotePath();

    /**
     * Get remote file type
     * 
     * @return - file type
     */
    String getType();

    /**
     * Get revision integration data
     * 
     * @return - array of data
     */
    IRevisionIntegrationData[] getIntegrationData();

    /**
     * Get name of client
     * 
     * @return - perforce client workspace name
     */
    String getClient();

    /**
     * Get charset of revision
     * 
     * @return - charset name
     */
    String getCharset();

    /**
     * Get connection
     * 
     * @return - p4 connection
     */
    IP4Connection getConnection();

    /**
     * Was this revision generated by the connection owner?
     * 
     * @return - true if author of this revision is the same as the user
     *         associated with the p4 connection, false otherwise
     */
    boolean isModifiedByOwner();

}
