package com.perforce.team.ui;

/*
 * Copyright (c) 2003 Perforce Software.  All rights reserved.
 *
 */

/**
 * UI Constants
 * 
 */
public interface IPerforceUIConstants {

    /**
     * ICON_PATH
     */
    String ICON_PATH = "icons/"; //$NON-NLS-1$

    // Normal

    /**
     * IMG_REFRESH
     */
    String IMG_REFRESH = "normal/refresh.png"; //$NON-NLS-1$

    /**
     * IMG_CLEAR
     */
    String IMG_CLEAR = "normal/clear.png"; //$NON-NLS-1$

    /**
     * IMG_NEW_CHANGELIST
     */
    String IMG_NEW_CHANGELIST = "normal/new_changelist.png"; //$NON-NLS-1$

    /**
     * IMG_JOB_COLUMNS
     */
    String IMG_JOB_COLUMNS = "normal/job_columns.png"; //$NON-NLS-1$

    /**
     * IMG_CLEAR_FILTER
     */
    String IMG_CLEAR_FILTER = "normal/clear_filter.png"; //$NON-NLS-1$

    /**
     * IMG_SET_FILTER
     */
    String IMG_SET_FILTER = "normal/set_filter.png"; //$NON-NLS-1$

    // Disabled

    /**
     * IMG_REFRESH_DISABLED
     */
    String IMG_REFRESH_DISABLED = "disabled/refresh.png"; //$NON-NLS-1$

    /**
     * IMG_CLEAR_DISABLED
     */
    String IMG_CLEAR_DISABLED = "disabled/clear.png"; //$NON-NLS-1$

    /**
     * IMG_JOB_COLUMNS_DISABLED
     */
    String IMG_JOB_COLUMNS_DISABLED = "disabled/job_columns.png"; //$NON-NLS-1$

    /**
     * IMG_CLEAR_FILTER_DISABLED
     */
    String IMG_CLEAR_FILTER_DISABLED = "disabled/clear_filter.png"; //$NON-NLS-1$

    /**
     * IMG_SET_FILTER_DISABLED
     */
    String IMG_SET_FILTER_DISABLED = "disabled/set_filter.png"; //$NON-NLS-1$

    // Enabled

    /**
     * IMG_REFRESH_ENABLED
     */
    String IMG_REFRESH_ENABLED = "enabled/refresh.png"; //$NON-NLS-1$

    /**
     * IMG_CLEAR_ENABLED
     */
    String IMG_CLEAR_ENABLED = "enabled/clear.png"; //$NON-NLS-1$

    /**
     * IMG_NEW_CHANGELIST_ENABLED
     */
    String IMG_NEW_CHANGELIST_ENABLED = "enabled/new_changelist.png"; //$NON-NLS-1$

    /**
     * IMG_JOB_COLUMNS_ENABLED
     */
    String IMG_JOB_COLUMNS_ENABLED = "enabled/job_columns.png"; //$NON-NLS-1$

    /**
     * IMG_CLEAR_FILTER_ENABLED
     */
    String IMG_CLEAR_FILTER_ENABLED = "enabled/clear_filter.png"; //$NON-NLS-1$

    /**
     * IMG_SET_FILTER_ENABLED
     */
    String IMG_SET_FILTER_ENABLED = "enabled/set_filter.png"; //$NON-NLS-1$

    // Decorator icons

    /**
     * IMG_DEC_ADD
     */
    String IMG_DEC_ADD = "decorations/add.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_EDIT
     */
    String IMG_DEC_EDIT = "decorations/edit.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_DELETE
     */
    String IMG_DEC_DELETE = "decorations/delete.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_SYNC
     */
    String IMG_DEC_SYNC = "decorations/sync.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_NOTSYNC
     */
    String IMG_DEC_NOTSYNC = "decorations/notsync.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_LOCK
     */
    String IMG_DEC_LOCK = "decorations/lock.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_UNRESOLVED
     */
    String IMG_DEC_UNRESOLVED = "decorations/unresolved.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_EDIT_OTHER
     */
    String IMG_DEC_EDIT_OTHER = "decorations/edit_other.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_ADD_OTHER
     */
    String IMG_DEC_ADD_OTHER = "decorations/add_other.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_DELETE_OTHER
     */
    String IMG_DEC_DELETE_OTHER = "decorations/delete_other.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_OFFLINE
     */
    String IMG_DEC_OFFLINE = "decorations/connection_offline.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_IGNORE
     */
    String IMG_DEC_IGNORE = "decorations/ignored.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_LOCAL
     */
    String IMG_DEC_LOCAL = "decorations/local_only.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_BRANCH
     */
    String IMG_DEC_BRANCH = "decorations/branch.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_INTEGRATE
     */
    String IMG_DEC_INTEGRATE = "decorations/integrate.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_BRANCH_OTHER
     */
    String IMG_DEC_BRANCH_OTHER = "decorations/branch_other.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_INTEGRATE_OTHER
     */
    String IMG_DEC_INTEGRATE_OTHER = "decorations/integrate_other.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_ADD_FUNC
     */
    String IMG_DEC_ADD_FUNC = "decorations/add_func.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_EDIT_FUNC
     */
    String IMG_DEC_EDIT_FUNC = "decorations/edit_func.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_DELETE_FUNC
     */
    String IMG_DEC_DELETE_FUNC = "decorations/delete_func.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_SHELVED
     */
    String IMG_DEC_SHELVED = "decorations/shelved.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_SANDBOX
     */
    String IMG_DEC_SANDBOX = "decorations/sandbox_ovl.png"; //$NON-NLS-1$

    /**
     * IMG_DEC_SANDBOX
     */
    String IMG_DEC_STREAM = "decorations/stream_ovl.png"; //$NON-NLS-1$

    // Changelist icons

    /**
     * IMG_CHG_OUR_ALL
     */
    String IMG_CHG_OUR_ALL = "perforce/mult_your_pending.png"; //$NON-NLS-1$

    /**
     * IMG_CHG_OTHER_ALL
     */
    String IMG_CHG_OTHER_ALL = "perforce/mult_their_pending.png"; //$NON-NLS-1$

    /**
     * IMG_CHG_OUR
     */
    String IMG_CHG_OUR = "perforce/your_pending.png"; //$NON-NLS-1$

    /**
     * IMG_CHG_OTHER
     */
    String IMG_CHG_OTHER = "perforce/their_pending.png"; //$NON-NLS-1$

    /**
     * IMG_CHG_JOB
     */
    String IMG_CHG_JOB = "perforce/job.png"; //$NON-NLS-1$

    /**
     * IMG_CHG_SUBMITTED
     */
    String IMG_CHG_SUBMITTED = "perforce/submitted.png"; //$NON-NLS-1$

    // Job icons

    /**
     * IMG_JOB_FIELD_SELECT
     */
    String IMG_JOB_FIELD_SELECT = "job/select.png"; //$NON-NLS-1$

    /**
     * IMG_JOB_FIELD_WORD
     */
    String IMG_JOB_FIELD_WORD = "job/word.png"; //$NON-NLS-1$

    /**
     * IMG_JOB_FIELD_TEXT
     */
    String IMG_JOB_FIELD_TEXT = "job/text.png"; //$NON-NLS-1$

    // Depot view icons

    /**
     * IMG_DEPOT_FOLDER
     */
    String IMG_DEPOT_FOLDER = "perforce/depot_folder.png"; //$NON-NLS-1$

    /**
     * IMG_DEPOT_SMALL_P4
     */
    String IMG_DEPOT_SMALL_P4 = "perforce/small_p4.png"; //$NON-NLS-1$

    /**
     * IMG_DEPOT_DEPOT
     */
    String IMG_DEPOT_DEPOT = "perforce/depot.png"; //$NON-NLS-1$

    /**
     * IMG_DEPOT_REMOTE
     */
    String IMG_DEPOT_REMOTE = "perforce/depot_remote.png"; //$NON-NLS-1$

    /**
     * IMG_DEPOT_SPEC
     */
    String IMG_DEPOT_SPEC = "perforce/depot_spec.png"; //$NON-NLS-1$

    /**
     * IMG_DEPOT_STREAM
     */
    String IMG_DEPOT_STREAM = "perforce/depot_stream.png"; //$NON-NLS-1$

    /**
     * IMG_DEPOT_STREAM_FOLDER
     */
    String IMG_DEPOT_STREAM_FOLDER = "perforce/depot_stream_folder.png"; //$NON-NLS-1$

    /**
     * IMG_DEPOT_CONNECTION
     */
    String IMG_DEPOT_CONNECTION = "views/server_connection.png"; //$NON-NLS-1$

    /**
     * IMG_DEPOT_CONNECTION_OFFLINE
     */
    String IMG_DEPOT_CONNECTION_OFFLINE = "views/server_connection_offline.png"; //$NON-NLS-1$

    // Streams icons
    
    /**
     * IMG_DEPOT_STREAM
     */
    String IMG_STREAM = "perforce/stream.png"; //$NON-NLS-1$

    // History view icons

    /**
     * IMG_HISTORY
     */
    String IMG_HISTORY = "views/history.png"; //$NON-NLS-1$

    // Submitted view icons

    /**
     * IMG_REVISION_ADD
     */
    String IMG_REVISION_ADD = "views/submitted/revision-add.png"; //$NON-NLS-1$

    /**
     * IMG_REVISION_BRANCH
     */
    String IMG_REVISION_BRANCH = "views/submitted/revision-branch.png"; //$NON-NLS-1$

    /**
     * IMG_REVISION_DELETE
     */
    String IMG_REVISION_DELETE = "views/submitted/revision-delete.png"; //$NON-NLS-1$

    /**
     * IMG_REVISION_EDIT
     */
    String IMG_REVISION_EDIT = "views/submitted/revision-edit.png"; //$NON-NLS-1$

    /**
     * IMG_REVISION_INTEGRATE
     */
    String IMG_REVISION_INTEGRATE = "views/submitted/revision-integrate.png"; //$NON-NLS-1$

    /**
     * IMG_REVISION_PURGE
     */
    String IMG_REVISION_PURGE = "views/submitted/revision-purge.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_FILE
     */
    String IMG_SHELVE_FILE = "views/shelved/file.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_FILE_ADD
     */
    String IMG_SHELVE_FILE_ADD = "views/shelved/add.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_FILE_BRANCH
     */
    String IMG_SHELVE_FILE_BRANCH = "views/shelved/branch.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_FILE_DELETE
     */
    String IMG_SHELVE_FILE_DELETE = "views/shelved/delete.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_FILE_EDIT
     */
    String IMG_SHELVE_FILE_EDIT = "views/shelved/edit.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_FILE_INTEGRATE
     */
    String IMG_SHELVE_FILE_INTEGRATE = "views/shelved/integrate.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_FILE_MOVEADD
     */
    String IMG_SHELVE_FILE_MOVEADD = "views/shelved/moveadd.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_FILE_MOVEDELETE
     */
    String IMG_SHELVE_FILE_MOVEDELETE = "views/shelved/movedelete.png"; //$NON-NLS-1$

    /**
     * IMG_MARK_ADD
     */
    String IMG_MARK_ADD = "normal/mark_add.png"; //$NON-NLS-1$

    /**
     * IMG_CHECK_OUT
     */
    String IMG_CHECK_OUT = "normal/checkout.png"; //$NON-NLS-1$

    /**
     * IMG_MARK_DELETE
     */
    String IMG_MARK_DELETE = "normal/mark_delete.png"; //$NON-NLS-1$

    /**
     * IMG_DIFF
     */
    String IMG_DIFF = "normal/diff.png"; //$NON-NLS-1$

    /**
     * IMG_REVERT
     */
    String IMG_REVERT = "normal/revert.png"; //$NON-NLS-1$

    /**
     * IMG_BRANCH
     */
    String IMG_BRANCH = "normal/branch.png"; //$NON-NLS-1$

    /**
     * IMG_INTEGRATE
     */
    String IMG_INTEGRATE = "normal/integrate.png"; //$NON-NLS-1$

    /**
     * IMG_RESOLVE
     */
    String IMG_RESOLVE = "normal/resolve.png"; //$NON-NLS-1$

    /**
     * IMG_INTERACTIVE
     */
    String IMG_INTERACTIVE = "normal/interactive.png"; //$NON-NLS-1$

    /**
     * IMG_CHECKED
     */
    String IMG_CHECKED = "perforce/checked.png"; //$NON-NLS-1$

    /**
     * IMG_LINK
     */
    String IMG_LINK = "normal/link.png"; //$NON-NLS-1$

    /**
     * IMG_DATES
     */
    String IMG_DATES = "normal/dates.png"; //$NON-NLS-1$

    /**
     * IMG_COMPARE
     */
    String IMG_COMPARE = "normal/compare.png"; //$NON-NLS-1$

    /**
     * IMG_LOCAL_MODE
     */
    String IMG_LOCAL_MODE = "normal/local_history.png"; //$NON-NLS-1$

    /**
     * IMG_REMOTE_MODE
     */
    String IMG_REMOTE_MODE = "normal/remote_history.png"; //$NON-NLS-1$

    /**
     * IMG_ALL_MODE
     */
    String IMG_ALL_MODE = "normal/all_history.png"; //$NON-NLS-1$

    /**
     * IMG_SYNC
     */
    String IMG_SYNC = "normal/sync.png"; //$NON-NLS-1$

    /**
     * IMG_SUBMIT
     */
    String IMG_SUBMIT = "normal/submit.png"; //$NON-NLS-1$

    // Labels view icons

    /**
     * IMG_LABEL
     */
    String IMG_LABEL = "views/label.png"; //$NON-NLS-1$

    // Shelve view icons

    /**
     * IMG_SHELVE
     */
    String IMG_SHELVE = "views/shelve.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_ACTION
     */
    String IMG_SHELVE_ACTION = "normal/shelve.png"; //$NON-NLS-1$

    /**
     * IMG_UNSHELVE
     */
    String IMG_UNSHELVE = "normal/unshelve.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_ADD
     */
    String IMG_SHELVE_ADD = "normal/shelve_add.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_UPDATE
     */
    String IMG_SHELVE_UPDATE = "normal/shelve_update.png"; //$NON-NLS-1$

    /**
     * IMG_SHELVE_DELETE
     */
    String IMG_SHELVE_DELETE = "normal/shelve_delete.png"; //$NON-NLS-1$

    /**
     * IMG_EMPTY
     */
    String IMG_EMPTY = "normal/empty.png"; //$NON-NLS-1$

    /**
     * IMG_CHECK_CONSISTENCY
     */
    String IMG_CHECK_CONSISTENCY = "normal/check_consistency.png"; //$NON-NLS-1$

    // Misc view icons

    /**
     * IMG_UNMANAGED_FILE_ECLIPSE
     */
    String IMG_UNMANAGED_FILE_ECLIPSE = "perforce/unmanaged_ec.png"; //$NON-NLS-1$

    /**
     * IMG_UNMANAGED_FILE_P4
     */
    String IMG_UNMANAGED_FILE_P4 = "perforce/small_p4.png"; //$NON-NLS-1$

    // Sharing wizard

    /**
     * IMG_SHARE_WIZARD
     */
    String IMG_SHARE_WIZARD = "perforce/wizard.png"; //$NON-NLS-1$

    /**
     * IMG_IMPORT_WIZARD
     */
    String IMG_IMPORT_WIZARD = "perforce/import_wizard.png"; //$NON-NLS-1$

    /**
     * IMG_STREAM_WIZARD
     */
    String IMG_STREAM_WIZARD = "perforce/stream_wizard.png"; //$NON-NLS-1$

    /**
     * IMG_LOADING
     */
    String IMG_LOADING = "perforce/hourglass.png"; //$NON-NLS-1$

    /**
     * IMG_COLLAPSE
     */
    String IMG_COLLAPSE = "normal/collapseall.png"; //$NON-NLS-1$

    /**
     * IMG_EXPAND_ALL
     */
    String IMG_EXPAND_ALL = "normal/expandall.png"; //$NON-NLS-1$

    /**
     * IMG_UPDATE_ALL
     */
    String IMG_UPDATE_ALL = "normal/update_all.png"; //$NON-NLS-1$

    /**
     * IMG_COMMIT_ALL
     */
    String IMG_COMMIT_ALL = "normal/commit_all.png"; //$NON-NLS-1$

    /**
     * IMG_ADD
     */
    String IMG_ADD = "normal/add.png"; //$NON-NLS-1$

    /**
     * IMG_DELETE
     */
    String IMG_DELETE = "normal/delete.png"; //$NON-NLS-1$

    /**
     * IMG_EDIT
     */
    String IMG_EDIT = "normal/edit.png"; //$NON-NLS-1$

    /**
     * IMG_PROPERTIES
     */
    String IMG_PROPERTIES = "normal/properties.png"; //$NON-NLS-1$

    /**
     * IMG_PREFERENCES
     */
    String IMG_PREFERENCES = "views/preferences.png"; //$NON-NLS-1$

    /**
     * IMG_TIME_LAPSE
     */
    String IMG_TIME_LAPSE = "normal/time_lapse.png"; //$NON-NLS-1$

    /**
     * IMG_SHOW_FILE_ACTIONS
     */
    String IMG_SHOW_FILE_ACTIONS = "normal/show_actions.png"; //$NON-NLS-1$

    /**
     * IMG_BRANCHES
     */
    String IMG_BRANCHES = "normal/branches.png"; //$NON-NLS-1$

    /**
     * IMG_CHECK
     */
    String IMG_CHECK = "normal/checked.png"; //$NON-NLS-1$

    /**
     * IMG_CHECK
     */
    String IMG_UNCHECK = "normal/unchecked.png"; //$NON-NLS-1$

    /**
     * IMG_FLAT_LAYOUT
     */
    String IMG_FLAT_LAYOUT = "normal/flat_layout.png"; //$NON-NLS-1$

    /**
     * IMG_TREE_LAYOUT
     */
    String IMG_TREE_LAYOUT = "normal/tree_layout.png"; //$NON-NLS-1$

    /**
     * IMG_COMPRESSED_LAYOUT
     */
    String IMG_COMPRESSED_LAYOUT = "normal/compressed_folders_layout.png"; //$NON-NLS-1$

    // Editor icons

    /**
     * IMG_JOB_EDITOR
     */
    String IMG_JOB_EDITOR = "perforce/job_editor.png"; //$NON-NLS-1$

    /**
     * IMG_JOB_EDITOR
     */
    String IMG_SUBMITTED_EDITOR = "perforce/submitted_editor.png"; //$NON-NLS-1$

    /**
     * IMG_JOB_EDITOR
     */
    String IMG_SHELVED_EDITOR = "perforce/shelved_editor.png"; //$NON-NLS-1$

    /**
     * IMG_FIND
     */
    String IMG_FIND = "normal/find.png"; //$NON-NLS-1$

    /**
     * IMG_VIEW_LINE
     */
    String IMG_VIEW_LINE = "normal/view_line.png"; //$NON-NLS-1$

    /**
     * IMG_VIEW_LINE_EXCLUDE
     */
    String IMG_VIEW_LINE_EXCLUDE = "normal/view_line_exclude.png"; //$NON-NLS-1$

    /**
     * IMG_VIEW_LINE_OVERLAY
     */
    String IMG_VIEW_LINE_OVERLAY = "normal/view_line_overlay.png"; //$NON-NLS-1$

    /**
     * IMG_ARROW_RIGHT
     */
    String IMG_ARROW_RIGHT = "normal/arrow_right.png"; //$NON-NLS-1$

    /**
     * IMG_CALENDAR
     */
    String IMG_CALENDAR = "normal/calendar.png"; //$NON-NLS-1$

    /**
     * IMG_FILTER_ICON_MENU
     */
    String IMG_FILTER_ICON_MENU = "perforce/filter_icon_menu.png"; //$NON-NLS-1$

    // Preferences

    /**
     * PREF_SHOW_MARKERS
     */
    String PREF_SHOW_MARKERS = "pref_show_markers"; //$NON-NLS-1$

    /**
     * PREF_NEW_OPEN_ADD
     */
    String PREF_NEW_OPEN_ADD = "pref_new_open_add"; //$NON-NLS-1$

    /**
     * PREF_OPEN_DEFAULT
     */
    String PREF_OPEN_DEFAULT = "pref_open_default"; //$NON-NLS-1$

    /**
     * PREF_MARK_UNMANAGED_FILES
     */
    String PREF_MARK_UNMANAGED_FILES = "pref_mark_unmanaged"; //$NON-NLS-1$

    /**
     * PREF_MARK_UNMANAGED_FILES_DEFAULT
     */
    String PREF_MARK_UNMANAGED_FILES_DEFAULT = "pref_mark_unmanaged_default"; //$NON-NLS-1$

    /**
     * PREF_REFACTOR_SUPPORT
     */
    String PREF_REFACTOR_SUPPORT = "pref_refactor_support"; //$NON-NLS-1$

    /**
     * PREF_REFACTOR_SAVE_SUPPORT
     */
    String PREF_REFACTOR_SAVE_SUPPORT = "pref_refactor_save_support"; //$NON-NLS-1$

    /**
     * PREF_REFACTOR_USE_MOVE
     */
    String PREF_REFACTOR_USE_MOVE = "pref_refactor_use_move"; //$NON-NLS-1$

    /**
     * PREF_DELETE_PROJECT_FILES
     */
    String PREF_DELETE_PROJECT_FILES = "pref_delete_project_files"; //$NON-NLS-1$

    /**
     * PREF_DELETE_LINKED_RESOURCES
     */
    String PREF_DELETE_LINKED_RESOURCES = "PREF_DELETE_LINKED_RESOURCES"; //$NON-NLS-1$

    /**
     * PREF_LOG_COMMAND
     */
    String PREF_LOG_COMMAND = "pref_log_command"; //$NON-NLS-1$

    /**
     * PREF_CONSOLE_COMMAND_COLOUR
     */
    String PREF_CONSOLE_COMMAND_COLOUR = "pref_console_command_colour"; //$NON-NLS-1$

    /**
     * PREF_CONSOLE_MESSAGE_COLOUR
     */
    String PREF_CONSOLE_MESSAGE_COLOUR = "pref_console_message_colour"; //$NON-NLS-1$

    /**
     * PREF_CONSOLE_ERROR_COLOUR
     */
    String PREF_CONSOLE_ERROR_COLOUR = "pref_console_error_colour"; //$NON-NLS-1$

    /**
     * PREF_CONSOLE_FONT
     */
    String PREF_CONSOLE_FONT = "com.perforce.team.ui.consoleFont"; //$NON-NLS-1$

    /**
     * PREF_CONSOLE_COMMANDS
     */
    String PREF_CONSOLE_COMMANDS = "com.perforce.team.ui.commandsMax"; //$NON-NLS-1$

    /**
     * PREF_CONSOLE_COMMAND_OUTPUT_HIDE_LARGE
     */
    String PREF_CONSOLE_COMMAND_OUPUT_HIDE_LARGE = "pref_console_command_ouput_hide_large"; //$NON-NLS-1$

    /**
     * PREF_CONSOLE_TIMESTAMP
     */
    String PREF_CONSOLE_TIMESTAMP = "com.perforce.team.ui.consoleTimestamp"; //$NON-NLS-1$

    /**
     * PREF_FILE_FORMAT
     */
    String PREF_FILE_FORMAT = "pref_file_format"; //$NON-NLS-1$

    /**
     * PREF_PROJECT_FORMAT
     */
    String PREF_PROJECT_FORMAT = "pref_project_format"; //$NON-NLS-1$

    /**
     * PREF_IGNORED_TEXT
     */
    String PREF_IGNORED_TEXT = "pref_ignored_text"; //$NON-NLS-1$

    /**
     * PREF_FILE_OPEN_ICON
     */
    String PREF_FILE_OPEN_ICON = "pref_file_open_icon"; //$NON-NLS-1$

    /**
     * PREF_FILE_SYNC_ICON
     */
    String PREF_FILE_SYNC_ICON = "pref_file_sync_icon"; //$NON-NLS-1$

    /**
     * PREF_FILE_SYNC2_ICON
     */
    String PREF_FILE_SYNC2_ICON = "pref_file_sync2_icon"; //$NON-NLS-1$

    /**
     * PREF_FILE_UNRESOLVED_ICON
     */
    String PREF_FILE_UNRESOLVED_ICON = "pref_file_unresolved_icon"; //$NON-NLS-1$

    /**
     * PREF_FILE_LOCK_ICON
     */
    String PREF_FILE_LOCK_ICON = "pref_file_lock_icon"; //$NON-NLS-1$

    /**
     * PREF_FILE_OTHER_ICON
     */
    String PREF_FILE_OTHER_ICON = "pref_file_other_icon"; //$NON-NLS-1$

    /**
     * PREF_PROJECT_ICON
     */
    String PREF_PROJECT_ICON = "pref_project_icon"; //$NON-NLS-1$

    /**
     * PREF_IGNORED_ICON
     */
    String PREF_IGNORED_ICON = "pref_ignored_icon"; //$NON-NLS-1$

    /**
     * PREF_LOCAL_ONLY_ICON
     */
    String PREF_LOCAL_ONLY_ICON = "pref_local_only_icon"; //$NON-NLS-1$

    /**
     * PREF_STREAM_SANDBOX_ICON (decoration on connection)
     */
    String PREF_STREAM_SANDBOX_ICON = "pref_stream_sandbox_icon"; //$NON-NLS-1$

    /**
     * PREF_STREAM_SANDBOX_PROJECT_ICON (decoration on project)
     */
    String PREF_STREAM_SANDBOX_PROJECT_ICON = "pref_stream_sandbox_project_icon"; //$NON-NLS-1$

    /**
     * PREF_RETRIEVE_NUM_JOBS
     */
    String PREF_RETRIEVE_NUM_JOBS = "pref_retrieve_num_jobs"; //$NON-NLS-1$

    /**
     * PREF_RETRIEVE_NUM_CHANGES
     */
    String PREF_RETRIEVE_NUM_CHANGES = "pref_retrieve_num_changes"; //$NON-NLS-1$

    /**
     * PREF_RETRIEVE_NUM_STREAMS
     */
    String PREF_RETRIEVE_NUM_STREAMS = "pref_retrieve_num_streams"; //$NON-NLS-1$
    
    /**
     * PREF_STREAM_DISPLAY
     */
    String PREF_STREAM_DISPLAY = "pref_display_stream_name_root"; //$NON-NLS-1$

    /**
     * PREF_RESOLVE_MIGRATED
     */
    String PREF_RESOLVE_MIGRATED = "pref_resolve_migrated_to_2012.3"; //$NON-NLS-1$
    
    /**
     * PREF_RESOLVE_DEFAULT_MODE
     */
    String PREF_RESOLVE_DEFAULT_MODE = "pref_resolve_default_mode"; //$NON-NLS-1$
    
    /**
     * PREF_RESOLVE_DEFAULT_ACTION
     */
    String PREF_RESOLVE_DEFAULT_ACTION = "pref_resolve_default_action"; //$NON-NLS-1$
    
    /**
     * PREF_RESOLVE_MERGE_BINARY_AS_TEXT
     */
    String PREF_RESOLVE_MERGE_BINARY_AS_TEXT = "pref_resolve_merge_binary_as_text"; //$NON-NLS-1$
    
    /**
     * PREF_RESOLVE_INTERACTIVE_MERGE_TOOL
     */
    String PREF_RESOLVE_INTERACTIVE_MERGE_TOOL = "pref_resolve_interactive_merge_tool"; //$NON-NLS-1$
    
    /**
     * Values are: always, never, prompt
     */
	String PREF_CLIENT_SWITCH_OPTION = "pref_client_switch_option";//$NON-NLS-1$
	
	String PREF_CLIENT_ROOT_PARENT_DEFAULT="pref_client_root_parent_default";//$NON-NLS-1$

	/**
	 * Values are: manual, auto
	 */
	String PREF_CLIENT_SWITCH_ON_STREAM_OPERATOIN = "pref_client_switch_on_stream_option";//$NON-NLS-1$

	/**
	 * Values are: true, false
	 */
	String PREF_CLIENT_SWITCH_NO_WARN = "pref_client_switch_no_warn";//$NON-NLS-1$

	/**
	 * Controlling dialog visibility on "remove from workspace"
	 */
	String PREF_PROMPT_ON_DELETING_MANAGED_FOLDERS = "pref_prompt_on_deleting_managed_folders";//$NON-NLS-1$

	/**
	 * Controlling whether "refresh the Perforce revision on refresh (F5)"
	 */
	String PREF_REFRESH_REVISION_ON_REFRESH = "pref_refresh_revision_on_refresh";//$NON-NLS-1$
	
	/**
	 * Controlling marker decoration "disable marker decoration"
	 */
	String PREF_DISABLE_MARKER_DECORATION = "pref_disable_marker_decoration";//$NON-NLS-1$

	// File text decoration

    /**
     * SHOW_FILE_REVISION
     */
    int SHOW_FILE_REVISION = 0x01;

    /**
     * SHOW_FILE_TYPE
     */
    int SHOW_FILE_TYPE = 0x02;

    /**
     * SHOW_FILE_ACTION
     */
    int SHOW_FILE_ACTION = 0x04;

    // Project text decoration

    /**
     * SHOW_PROJECT_PORT
     */
    int SHOW_PROJECT_PORT = 0x01;

    /**
     * SHOW_PROJECT_CLIENT
     */
    int SHOW_PROJECT_CLIENT = 0x02;

    /**
     * SHOW_PROJECT_USER
     */
    int SHOW_PROJECT_USER = 0x04;

    // Decoration icon positions

    /**
     * ICON_TOP_LEFT
     */
    int ICON_TOP_LEFT = 0x01;

    /**
     * ICON_TOP_RIGHT
     */
    int ICON_TOP_RIGHT = 0x02;

    /**
     * ICON_BOTTOM_LEFT
     */
    int ICON_BOTTOM_LEFT = 0x04;

    /**
     * ICON_BOTTOM_RIGHT
     */
    int ICON_BOTTOM_RIGHT = 0x08;

	String ALWAYS = "always";//$NON-NLS-1$

	String NEVER = "never";//$NON-NLS-1$

	String PROMPT = "prompt";//$NON-NLS-1$

	String STREAM_SWITCH_STREAM_WITH_DIFF_CLIENT = "diffStreamDiffClient";//$NON-NLS-1$

	String STREAM_SWITCH_STREAM_WITH_SAME_CLIENT = "diffStreamSameClient";//$NON-NLS-1$

	String DEC_OFFLINE = "*Offline*";//$NON-NLS-1$

	String DEC_SANDBOX = "*Sandbox*";//$NON-NLS-1$
	
	String RESOLVE_AUTO = "auto";//$NON-NLS-1$
	String RESOLVE_INTERACTIVE = "interactive";//$NON-NLS-1$
	String RESOLVE_PROMPT = "prompt";//$NON-NLS-1$
	

}
