﻿# Perforce: Publish assets
Jenkins can automatically shelve or submit build assets to a Perforce Helix Core Server. For example, you could use this function to publish a PDF version of the release document to the Helix Server you use for the build or even a different Helix Server if required.   

## Perforce Credentials
- Select the credentials for the project from the **Perforce credentials** dropdown. 

## Workspace behaviour
Use a unique Perforce Workspace to Publish the assets. The Client View should be as narrow as possible, ideally only mapping the assets that need to be published. Adding a postfix of `-publish` to the Workspace will help to identify its purpose. 
**Note:** Many of the workspace fields can include environment variables to help define their value. We recommend that variables are used in the **Workspace name** to enable you to identify builds. For more information about environment variables, see [Variable Expansion](VARIABLEEXPANSION.md).  
Perforce workspaces support the following behaviours: 
 - **Manual (custom view)**: Manually define the workspace view and sync options. Creates the workspace if it does not already exist or updates the workspace spec by setting the various options if it already exists. Jenkins will fill out the workspace root and may override the Clobber option. For details about manually configuring your workspace, see [Manual Workspace](WORKSPACEMANUAL.md).  
 - **Static (static view, master only)**: Uses a predefined workspace, the workspace must have a valid view and must already exist. The plugin user must either own the workspace or the spec must be unlocked allowing the plugin user to make edits. The workspace view remains static, but Jenkins will update other fields such as the workspace root and clobber option. For details about using a static predefined workspace, see [Static Workspace](WORKSPACESTATIC.md).  
 - **Template (view generated for each node)**: Uses a specified template to generate the workspace view. The name of the workspace is generated using the **Workspace Name Format** field. This makes it an ideal choice for Matrix builds. For details about using a template to generate the workspace, see [Template Workspace](WORKSPACETEMPLATE.md).  
 - **Streams (view generated by Perforce for each node)**: Uses a specified stream to generate the workspace view. A virtual stream may help to filter the view and `+import` mappings when submitting assets to non-stream location. The name of the workspace is generated using the **Workspace Name Format** field.  
For details about using a stream to generate the workspace, see [Streams Workspace](WORKSPACESTREAMS.md).  
- **Spec File (load workspace spec from file in Perforce)**: Loads the workspace configuration from a depot file containing a client workspace spec. This is the same output as `p4 client -o` and the Spec depot `.p4s` format. The name of the Workspace must match the name of the client workspace spec. For details about using a spec file for your workspace, see [Spec File Workspace](WORKSPACESPECFILE.md).  

## Publish Options
Now complete the configuration by selecting one of the following change types:
- [Shelve change](#shelve-change). 
- [Submit change](#submit-change). 

### Shelve Change
![Shelve Assets](images/ShelveAsset.png)
1. **Publish options:** Select **Shelve change** from the dropdown list. 
2. **Description:** The change description used to shelve the assets to the Perforce Helix Server. `${VAR}` variables are expanded base on the system environment. For more information about environment variables, see [Variable Expansion](VARIABLEEXPANSION.md).  
3. **Options** there are a number of options that can be set to configure client behaviour: 
   - **Only publish on build success:** The assets will only be shelved when the build is successful.   
   - **Propagate deletes:** Select to enable files to be deleted when the asset is published.   
   - **Use MODTIME for consistency check:** Select to reconcile files with -m flag.   
   - **Revert opened file list:** Reverts open files in the pending changelist, but leaves the content in the workspace unchanged. Equivalent to `p4 revert -k`.   

Click the browser **Back** button to go back to the previous page. 

### Submit Change
![Submit Assets](images/SubmitAsset.png)
1. **Publish options:** Select **Submit change** from the dropdown list. 
2. **Description:** The change description used to submit the assets to the Perforce Helix Server. `${VAR}` variables are expanded base on the system environment. For more information about environment variables, see [Variable Expansion](VARIABLEEXPANSION.md).  
3. **Options** there are a number of options that can be set to configure client behavior: 
   - **Only publish on build success:** The assets will only be shelved when the build is successful.   
   - **Propagate deletes:** Select to enable files to be deleted when the asset is published.
   - **Use MODTIME for consistency check:** Select to reconcile files with -m flag.   
   - **Reopened files:** Submitted files are reopened, allowing subsequent modification.   

Click the browser **Back** button to go back to the previous page. 
