﻿_Online documentation for [Freestyle Project](https://www.perforce.com/manuals/jenkins/Content/P4Jenkins/freestyle-project-setup.html)_

# Freestyle Project Setup Guide
Freestyle projects are configured using the Jenkins graphical user interface. Once the job is complete you can view the script that Jenkins generates. This is a good way to learn what the scripts contain.  

## Add Credentials
The plugin makes use of the Jenkins Credential store, making it easier to manage the Helix Core Server (P4D) connection for multiple Jenkins jobs. 
For details about creating a **Perforce Password Credential** or **Perforce Ticket Credential**, see [Add a credential](CREDENTIALS.md). 

## Add a new Freestyle project
 1. From the Jenkins dashboard, click **New item** from the sidebar menu.
 2. Enter a name for the new project in the **Enter an item name** field at the top of the page.
 3. Click **Freestyle project**. 
 4. Click **OK** to start configuring your new Freestyle project. 
 5. **Description** (optional): enter a description for the project in the **Description** field. 

### Source Code Management
- To configure the project to use the Perforce server, click the **Perforce Software** radio button.  

### Perforce Credentials
- Select the credentials for the project from the **Perforce credentials** dropdown. 

### Workspace behavior
Perforce workspaces are configured on the Jenkins Job configuration page and support the following behaviours: 
**Note:** Many of the workspace fields can include environment variables to help define their value. We recommend that variables are used in the **Workspace name** to enable you to identify builds. For more information about environment variables, see [Variable Expansion](VARIABLEEXPANSION.md).  
 - **Manual (custom view)**: Manually define the workspace view, and sync options. Creates the workspace if it does not already exist or updates the workspace spec by setting the various options if it already exists. Jenkins will fill out the workspace root and may override the Clobber option. For details about manually configuring your workspace, see [Manual Workspace](WORKSPACEMANUAL.md).  
 - **Static (static view, master only)**: Uses a predefined workspace, the workspace must have a valid view and must already exist. The plugin user must either own the workspace or the spec must be unlocked allowing the plugin user to make edits. The workspace view remains static, but Jenkins will update other fields such as the workspace root, and clobber option. For details about using a static predefined workspace, see [Static Workspace](WORKSPACESTATIC.md).  
 - **Template (view generated for each node)**: Uses a specified template to generate the workspace view. The name of the workspace is generated using the **Workspace Name Format** field. This makes it an ideal choice for Matrix builds. For details about using a template to generate the workspace, see [Template Workspace](WORKSPACETEMPLATE.md).  
 - **Streams (view generated by Perforce for each node)**: Uses a specified stream to generate the workspace view. The name of the workspace is generated using the **Workspace Name Format** field. This makes it an ideal choice for Matrix builds. For details about using a stream to generate the workspace, see [Streams Workspace](WORKSPACESTREAMS.md).  
- **Spec File (load workspace spec from file in Perforce)**: Loads the workspace configuration from a depot file containing a client workspace spec. This is the same output as `p4 client -o` and the Spec depot `.p4s` format. The name of the Workspace must match the name of the client workspace spec. For details about using a spec file for your workspace, see [Spec File Workspace](WORKSPACESPECFILE.md).  

### Populate options
Perforce populates the workspace with the file revisions needed for the build, the options are:
 - **Automatic Cleanup and Sync:** Use when the Perforce Helix Server controls the files in the workspace. This is an efficient option that cleans and syncs file revisions in the workspace. Extra (non versioned files) are removed, missing and modified files re-added. This option is best for clean builds. For details about the **Automatic Cleanup and Sync** options, see [Automatic Cleanup and Sync](POPULATEAUTOCLEANSYNC.md).  
 - **Flush Workspace:** Use when files in the workspace are not added by the Perforce Helix Server. No file Sync or cleanup is attempted and no files are removed, but the workspace "have list" is updated. This is effectively the same as using the `p4 sync -k` command. For details about the **Flush Workspace** options, see [Flush Workspace](POPULATEFLUSH.md).  
 - **Forced Clean and Sync:** Not recommended because this option is very inefficient. Use if you do not trust the content of your workspace. Removes all of the files in the workspace root, including the build history, and then force syncs the required files. For details about the **Forced Clean and Sync** options, see [Forced Clean and Sync](POPULATEFORCEDCLEANSYNC.md).  
 - **Graph Force Clean and Sync:** Perforce Helix4Git required. Use for Perforce Graph and Hybrid only. Removes all of the files in the workspace root, including the build history, and then force syncs the required files. For details about the **Graph Force Clean and Sync** options, see [Graph Force Clean and Sync](POPULATEGRAPHFORCECLEANSYNC.md).
 - **Preview Check Only:** No file sync or cleanup is attempted, and the Workspace "have list" is not updated. This is effectively the same as using the `p4 sync -n` command. For details about the **Preview Check Only** options, see [Preview Check Only](POPULATEPREVIEWCHECKONLY.md). 
- **Sync Only:** Use if you have a hand-crafted build environment that you don't want to lose any files from. No cleanup is attempted and the sync will update all files (as **CLOBBER** is set) to the required revisions. This option is best for incremental builds and is mostly used for Pipeline builds. For details about the **Sync Only** options, see [Sync Only](POPULATESYNCONLY.md). 

### Parallel Sync
Parallel sync enables concurrent transfer of files between Jenkins and the Helix Server. Parallel  sync can greatly reduce the amount of time it takes to update a workspace, especially when connecting across a high latency network. 
Parallel sync must be enabled on the Helix Server (2014.1 or later). For more information on  parallel  sync, see  [Using  parallel  processing for submits and syncs](https://www.perforce.com/perforce/doc.current/manuals/p4sag/index.html#P4SAG/performance.parallel_processing.html)  in  [_Helix Core Server Administrator Guide: Fundamentals_](http://www.perforce.com/perforce/doc.current/manuals/p4sag/index.html).
Parallel sync is disabled by default, to enable parallel sync: 
1. Click the **Advanced** button. 
2. Select **Enabled**.
3. The parallel sync settings will depend on the capabilities of the Jenkins build machine and the Helix Server:
   - **Threads:**  Set the number of threads available for parallel sync.   
   - **Minimum Files:** If the number of files being sync'ed is less than this value, parallel sync is not used.   
   - **Minimum Bytes:** If the total size of files being sync'ed is less than this value, parallel sync is not used.   

### Polling build filters
When polling is used, changes can be filtered to not trigger a build. If the build has more than one filter, the filters are processed starting from the top of the list of filters. Filters can be dragged up or down the list to change the order they are processed in. 
Click the **Add a new build filter** button and select a filter from the dropdown list, options are:
- **Exclude changes from depot path:** Changes can be filtered to not trigger a build if all of the files within a change match the specified path. For examples, see [Exclude Changes From Depot Path](POLLBUILDFILTEREXCDEPOTPATH.md). 
- **Exclude changes from user:** Changes owned by the Perforce Helix Server user specified in the filter will not be built.
- **Exclude changes from outside Java pattern:** Changes can be filtered to not trigger a build if none of the files within a change match the Java patterns (regular expression) listed. For examples, see [Exclude Changes From Outside Java Pattern](POLLBUILDFILTEREXCJAVAPATTERN.md). 
- **Exclude changes outside view mask:** Changes can be filtered to not trigger a build if none of the files within a change are contained in the view mask. For examples, see [Exclude Changes Outside view mask](POLLBUILDFILTEREXCVIEWMASK.md).  
- **Polling per Change:** A build is carried out for every change that is submitted. The polling event will only return the oldest unbuilt change, resulting in incremental builds. 
- **Polling latest change:** A build is carried out for the latest change found during polling.
- **Polling latest change with pin:** In case of a pinned checkout, polling ignores the pin or the label specified in the checkout step and polls till the latest change.
### Repository browser
Repository browsing allows Jenkins to use an external browser, to navigate files and changes associated with a Jenkins build. The Helix Swam browser is recommended.  
To enable the feature select the browser from the **Repository browser** dropdown list, and provide the full URL to the browser.

![Repository Browser](images/repos.png)

Example of a link to a change in Swarm:
![Example Change in Swarm](images/swarm.png)

### Build Triggers
If no triggers are set, Jenkins will build based on the **Polling build filters** in use.  
- **Perforce triggered build:** Select to enable the Perforce Helix Server to trigger Jenkins to build based on an event, such as a submitted change. A triggered build requires an administrator to add a Perforce trigger. For more information on configuring Perforce triggered builds, see [Perforce Triggered Build](BUILDTRIGGERPERFORCE.md). 
- **Poll SCM:** Not recommended. Select to trigger a Jenkins job build based on the polling schedule entered in the field below the checkbox. The schedule is constructed using the Cron format, see the bubble help for **Poll SCM**. 
![Poll SCM with Example Schedule](images/trigger.png)
The example above runs a build Monday to Friday every 10 minutes. `H` is a time offset (calculated using a Hash of the Job name).  
**Caveats:**
-- You must use workspaces named using the recommended environment variables, see [Variable Expansion](VARIABLEEXPANSION.md).  
-- Do not use parameterized builds.
-- If you enable **Poll SCM**,  ensure that your **Auto build filters** are configured to suit regular builds. 

### Build
The P4-plugin supports unshelving of one or more shelved changes into your Jenkins workspace as a build step. 
To add unshelving as a build step, click the **Add build step** button and select **Perforce: Unshelve**. For more information about Perforce: Unshelve, see [Perforce: Unshelve](BUILDSTEPUNSHELVE.md). 

### Post-build Actions
Jenkins can carry out a number of actions once the build has completed.  If the build has more than one post-build action, the actions are processed starting from the top of the list of actions. Post-build actions can be dragged up or down the list to change the order they are processed in. 
Click the **Add post-build action** button and select an action from the dropdown list, options are:
- **Perforce: ApproveImpl review:** Perforce Helix Swarm required. Sets the Swarm review state when the build completes. For more information about using Perforce: ApproveImpl review, see [Perforce: ApproveImpl Review](POSTBUILDACTIONAPPROVEIMPL.md).  
- **Perforce: Cleanup:** Select to cleanup the workspace after the build. For more information about using Perforce: Cleanup, see [Perforce: Cleanup](POSTBUILDACTIONCLEANUP.md).  
- **Perforce: Label build:** Jenkins can tag builds automatically when the build completes. The Tags are stored in the Perforce Helix Server as Automatic Labels with the label view based on the workspace at the time of tagging. For more information about using Perforce: Label Build, see [Perforce: Label Build](POSTBUILDACTIONLABELBUILD.md).  
- **Perforce: Publish assets:** Jenkins can automatically shelve or submit build assets to the Perforce Helix Server. For example, you can use this function to publish a PDF of the release notes to the server. For more information about using Perforce: Publish Assets, see [Perforce: Publish Assets](POSTBUILDPUBLISHASSETS.md).   

## Save
 When you have finished configuring the job click **Save**.  

## Building
Now that you have configured your job it is ready to be built. For information about building jobs, see [Building Jobs](BUILDINGJOBS.md).  
