package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary.IClientOptions;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.server.IOptionsServer;
import hudson.Extension;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

import java.io.Serializable;
import java.util.logging.Logger;

public class StreamWorkspaceImpl extends Workspace implements Serializable {

	private static final long serialVersionUID = 1L;

	private final String streamName;

	private String streamAtChange = StringUtils.EMPTY;
	private String format;

	private static Logger logger = Logger.getLogger(StreamWorkspaceImpl.class
			.getName());

	public String getStreamName() {
		return streamName;
	}

	public String getStreamAtChange() {
		return streamAtChange;
	}
	@DataBoundSetter
	public void setStreamAtChange(String streamAtChange) {
		this.streamAtChange = streamAtChange;
	}

	public String getFormat() {
		return format;
	}

	@Override
	public String getName() {
		return format;
	}

	@Override
	public void setName(String name) {
		this.format = name;
	}

	@Override
	public WorkspaceType getType() {
		return WorkspaceType.STREAM;
	}

	@DataBoundConstructor
	public StreamWorkspaceImpl(String charset, boolean pinHost,
							   String streamName, String format) {
		super(charset, pinHost, false);
		this.streamName = streamName;
		this.format = format;
	}

	@Override
	public IClient setClient(IOptionsServer connection, String user)
			throws Exception {
		// expands Workspace name if formatters are used.
		String clientName = getFullName();

		IClient iclient = connection.getClient(clientName);
		if (iclient == null) {
			logger.info("P4: Creating stream client: " + clientName);
			Client implClient = new Client(connection);
			implClient.setName(clientName);
			implClient.setOwnerName(user);
			connection.createClient(implClient);
			iclient = connection.getClient(clientName);
		}

		// Owner set for use with p4maven
		iclient.setOwnerName(user);

		// Expand Stream name
		String streamFullName = getExpand().format(getStreamName(), true);
		iclient.setStream(streamFullName);

		if(StringUtils.isNotEmpty(streamAtChange)){
			String atChange = getExpand().format(streamAtChange, true);
			iclient.setStreamAtChange(Integer.parseInt(atChange));
		}
		else
		{
			// Need to remove the streamAtChange value if not set to cater for previous set values
			iclient.setStreamAtChange(-1);
		}

		// Set clobber on to ensure workspace is always good
		IClientOptions options = iclient.getOptions();
		options.setClobber(true);
		iclient.setOptions(options);

		return iclient;
	}

	@Extension
	@Symbol("streamSpec")
	public static final class DescriptorImpl extends WorkspaceDescriptor {

		@Override
		public String getDisplayName() {
			return "Streams (view generated by Perforce for each node)";
		}
	}
}