package com.perforce.hws.server;

/**
 * Enum defining the keys in an HWS configuration file..
 */
public enum ConfigurationKey {

    /**
     * Value for the Access-Control-Allow-Origin CORS header.
     */
    ACCESS_CONTROL_ALLOW_ORIGIN,

    /**
     * Value for the Access-Control-Allow-Headers CORS header.
     */
    ACCESS_CONTROL_ALLOW_HEADERS,

    /**
     * Value for the Access-Control-Request-Method CORS header.
     */
    ACCESS_CONTROL_REQUEST_METHOD,

    /**
     * Enable auto-trusting all new servers that this service is connecting to.
     * If previously trusted will throw an error if fingerprint changed.
     */
    AUTO_TRUST,

    /**
     * Allows access to run commands via
     * GET /api/p4d/v16.1/{server}/commands/{command}
     * or POST /api/p4d/v16.1/{server}/commands/{command}.
     * Each element in the array is either the name of a command to allow,
     * or an array of the command name and any required arguments.
     */
    COMMAND_WHITELIST,

    /**
     * The api level (e.g., "80") to use for P4 connections.
     * If set, we’ll use this instead of associating it with
     * the platform version we’re targeting.
     */
    DEFAULT_API_LEVEL,

    /**
     * Switch to enable GitFusion endpoints.
     */
    ENABLE_GIT_FUSION,

    /**
     * Configure the web server to use HTTPS. You must configure the
     * keystore file: see KEYSTORE_FILE setting. Related optional settings are:
     * KEYSTORE_PASSWORD, TRUSTSTORE_FILE, and TRUSTSTORE_PASSWORD.
     */
    ENABLE_HTTPS,

    /**
     * The enable man in middle attacks.
     */
    ENABLE_MAN_IN_MIDDLE_ATTACKS,

    /**
     * The depot name for Git Fusion data. This makes no sense to use
     * if ENABLE_GIT_FUSION is false.
     */
    GITFUSIONDEPOT,

    /**
     * The P4D to use for HWS login.
     */
    HWS_AUTH_P4D,

    /**
     * The port to respond to for new connections.
     */
    HWS_PORT,

    /**
     * The jwt signing key.
     */
    JWT_SIGNING_KEY,

    /**
     * The jwt timeout in seconds.
     */
    JWT_TIMEOUT_IN_SECONDS,

    /**
     * The keystore file for secure connections.
     */
    KEYSTORE_FILE,

    /**
     * The password for the keystore.
     */
    KEYSTORE_PASSWORD,

    /**
     * The maximum number of connections we’ll allow this
     * instance to acquire per P4PORT.
     */
    MAX_SERVER_CONNECTIONS,

    /**
     * The local directory where p4d configuration settings
     * files are stored. These are yaml files, named with the
     * value of P4DID.
     */
    P4DCONFIGDIR,

    /**
     * The prefix URL path.
     *
     * <p>Used when HWS is mounted in a servlet container under a context path.
     */
    PREFIX,

    /**
     * The request filter path.
     */
    REQUEST_FILTER_PATH,

    /**
     * The umask.
     */
    SETUMASK,

    /**
     * The gid.
     */
    SETGID,

    /**
     * The uid.
     */
    SETUID,

    /**
     * The system config path.
     */
    SYSTEM_CONFIG_PATH,

    /**
     * The path to the truststore file, if empty, will reuse the keystore.
     */
    TRUSTSTORE_FILE,

    /**
     * The password for the truststore file.
     */
    TRUSTSTORE_PASSWORD,

    /**
     * Local file path that indicates a list of allowed SSL fingerprints.
     */
    TRUST_FINGERPRINTS,

    /**
     * The webhooks.
     */
    WEBHOOKS,

    /**
     * The workspace dir.
     */
    WORKSPACE_DIR;
}
