package com.perforce.hws.server;

import com.perforce.hwsclient.models.P4dConfigId;

/**
 * Created by tristan on 3/24/16.
 */
public class P4dConfig extends P4dConfigId {

    private String P4PORT;

    private String P4CHARSET;

    private String APILEVEL;

    public String getAPILEVEL() {
        return APILEVEL;
    }

    public void setAPILEVEL(String APILEVEL) {
        this.APILEVEL = APILEVEL;
    }

    public String getP4CHARSET() {
        return P4CHARSET;
    }

    public void setP4CHARSET(String p4CHARSET) {
        P4CHARSET = p4CHARSET;
    }

    public String getP4PORT() {
        return P4PORT;
    }

    public void setP4PORT(String p4PORT) {
        P4PORT = p4PORT;
    }

    public boolean isSsl() {
        return getP4PORT().startsWith("ssl:");
    }

    public String getHostAndPort() {
        return isSsl() ? getP4PORT().substring("ssl:".length()) : getP4PORT();
    }

    public String toURIString() {
        String scheme = "p4java";
        if (isSsl()) {
            scheme = "p4javassl";
        }
        return String.format("%s://%s", scheme, getHostAndPort());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        P4dConfig p4dConfig = (P4dConfig) o;

        if (P4PORT != null ? !P4PORT.equals(p4dConfig.P4PORT) : p4dConfig.P4PORT != null)
            return false;
        if (P4CHARSET != null ? !P4CHARSET.equals(p4dConfig.P4CHARSET) : p4dConfig.P4CHARSET != null)
            return false;
        return APILEVEL != null ? APILEVEL.equals(p4dConfig.APILEVEL) : p4dConfig.APILEVEL == null;

    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (P4PORT != null ? P4PORT.hashCode() : 0);
        result = 31 * result + (P4CHARSET != null ? P4CHARSET.hashCode() : 0);
        result = 31 * result + (APILEVEL != null ? APILEVEL.hashCode() : 0);
        return result;
    }
}
