package com.perforce.hws.server;

/**
 * Represents an association of a single "platform version" to default configuration.
 */
public class PlatformVersion {

    private String name;
    private String defaultApiLevel;

    public PlatformVersion(String name, String defaultApiLevel) {
        this.defaultApiLevel = defaultApiLevel;
        this.name = name;
    }

    /**
     * The default associated p4d level that we ideally run against.
     *
     * This should ensure that against *future* versions of p4d, we can continue to run this SDK.
     *
     * @return The string value in
     */
    public String getDefaultApiLevel() {
        return defaultApiLevel;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PlatformVersion that = (PlatformVersion) o;

        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        return defaultApiLevel != null ? defaultApiLevel.equals(that.defaultApiLevel) : that.defaultApiLevel == null;

    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (defaultApiLevel != null ? defaultApiLevel.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return name;
    }
}
