package com.perforce.hws.server;

import java.util.Arrays;

/**
 * Created by tristan on 3/24/16.
 */
public class PlatformVersions {
	
    /** The v2016_1_0. */
    public static PlatformVersion v2016_1_0 = new PlatformVersion("v16.1", "80");

    /** The supported versions. */
    public static PlatformVersion[] SUPPORTED_VERSIONS = {v2016_1_0};

    /**
     * Checks if is supported version.
     *
     * @param name the name
     * @return true, if is supported version
     */
    public static boolean isSupportedVersion(final String name) {
        return Arrays.stream(SUPPORTED_VERSIONS)
                .anyMatch(v -> name.equals(v.getName()));
    }

    /**
     * Gets the version.
     *
     * @param name the name
     * @return the version
     */
    public static PlatformVersion getVersion(final String name) {
        return Arrays.stream(SUPPORTED_VERSIONS)
                .filter(v -> name.equals(v.getName()))
                .findFirst().get();
    }
}
